package clinical.web.vo;

import clinical.utils.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: RangeInfo.java 543 2012-02-16 01:30:31Z bozyurt $
 */
public class RangeInfo {
	protected String lowBound;
	protected String uppBound;
	protected boolean includeLowBound;
	protected boolean includeUppBound;
	protected int numericType;
	/** the variable this range info is for */
	protected Object variable;
	private Double lowBoundNum, uppBoundNum;

	public final static int INTEGER = 1;
	public final static int FLOAT = 2;

	public RangeInfo() {
	}

	public RangeInfo(String lowBound, String uppBound, boolean includeLowBound,
			boolean includeUppBound, Object variable) {
		this.lowBound = lowBound;
		this.uppBound = uppBound;
		this.includeLowBound = includeLowBound;
		this.includeUppBound = includeUppBound;
		this.variable = variable;
		Number num = GenUtils.toNumber(lowBound);
		if (num instanceof Integer) {
			numericType = INTEGER;
		} else {
			numericType = FLOAT;
		}
		lowBoundNum = new Double(lowBound);
		uppBoundNum = new Double(uppBound);
	}

	public boolean wasInRange(String valueStr) {
		Number num = GenUtils.toNumber(valueStr);
		if (num == null) {
			return false;
		}
		Double value = new Double(valueStr);
		if (includeLowBound && includeUppBound) {
			return (lowBoundNum.doubleValue() <= value.doubleValue() && uppBoundNum
					.doubleValue() >= value.doubleValue());
		} else if (includeLowBound && !includeUppBound) {
			return (lowBoundNum.doubleValue() <= value.doubleValue() && uppBoundNum
					.doubleValue() > value.doubleValue());
		} else if (!includeLowBound && includeUppBound) {
			return (lowBoundNum.doubleValue() < value.doubleValue() && uppBoundNum
					.doubleValue() >= value.doubleValue());
		} else {
			return (lowBoundNum.doubleValue() < value.doubleValue() && uppBoundNum
					.doubleValue() > value.doubleValue());
		}
	}

	// ---------------------- setters --------------
	public void setLowBound(String newLowBound) {
		this.lowBound = newLowBound;
	}

	public void setUppBound(String newUppBound) {
		this.uppBound = newUppBound;
	}

	public void setIncludeLowBound(boolean newIncludeLowBound) {
		this.includeLowBound = newIncludeLowBound;
	}

	public void setIncludeUppBound(boolean newIncludeUppBound) {
		this.includeUppBound = newIncludeUppBound;
	}

	public void setVariable(Object newVariable) {
		this.variable = newVariable;
	}

	// ---------------------- getters --------------
	public String getLowBound() {
		return this.lowBound;
	}

	public String getUppBound() {
		return this.uppBound;
	}

	public boolean getIncludeLowBound() {
		return this.includeLowBound;
	}

	public boolean getIncludeUppBound() {
		return this.includeUppBound;
	}

	public int getNumericType() {
		return this.numericType;
	}

	public Object getVariable() {
		return this.variable;
	}

	public boolean withinRange(Number value) {
		boolean checked = false;
		if (includeLowBound) {
			checked = lowBoundNum.doubleValue() <= value.doubleValue();
		} else {
			checked = lowBoundNum.doubleValue() < value.doubleValue();
		}
		if (!checked)
			return false;
		if (includeUppBound) {
			checked = uppBoundNum.doubleValue() >= value.doubleValue();
		} else {
			checked = uppBoundNum.doubleValue() > value.doubleValue();
		}
		return checked;
	}
	
	public static String getFormattedRange(RangeInfo rangeInfo) {
		if (rangeInfo == null)
			return "";
		StringBuilder sb = new StringBuilder();
		if (rangeInfo.getIncludeLowBound()) {
			sb.append("[");
		} else {
			sb.append("(");
		}
		sb.append(rangeInfo.getLowBound()).append(" - ").append(
				rangeInfo.getUppBound());
		if (rangeInfo.getIncludeUppBound()) {
			sb.append("]");
		} else {
			sb.append(")");
		}
		return sb.toString();
	}

	public String toString() {
		StringBuilder sb = new StringBuilder(128);
		sb.append("RangeInfo::[");
		sb.append("lowBound=").append(lowBound).append(", upperBound=")
				.append(uppBound);
		sb.append(", variable=").append(variable.toString());
		sb.append(']');
		return sb.toString();
	}
}