package clinical.web.vo.upload;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: EnrolledSubject.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class EnrolledSubject implements Serializable{
	private static final long serialVersionUID = 1L;
	String subjectID;
	String researchGroup;
	String gender;
	
	public EnrolledSubject(String subjectID, String researchGroup, String gender) {
		super();
		this.subjectID = subjectID;
		this.researchGroup = researchGroup;
		this.gender = gender;
	}
	
	public String getSubjectID() {
		return subjectID;
	}
	public String getResearchGroup() {
		return researchGroup;
	}
	
	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("subjectID", subjectID);
		js.put("rg", researchGroup);
		js.put("gender", gender);
		return js;
	}
   
	public static EnrolledSubject initializeFromJSON(JSONObject js)
			throws JSONException {
		String subjectID = js.getString("subjectID");
		String rg = js.getString("rg");
		String gender = js.getString("gender");
		return new EnrolledSubject(subjectID, rg, gender);
	}

	public String getGender() {
		return gender;
	}

}
