package clinical.web.vo.upload;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ExperimentInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */

public class ExperimentInfo implements Serializable{
	private static final long serialVersionUID = 1L;
	String name;
	int expId;
	List<RGInfo> rgiList = new ArrayList<RGInfo>(5);
	List<ColEquipInfo> ceiList = new ArrayList<ColEquipInfo>(5);
	List<ProtocolInfo> protocolList = new ArrayList<ProtocolInfo>();
	List<EnrolledSubject> enrolledSubjects = new ArrayList<EnrolledSubject>();

	public ExperimentInfo(String name, int expId) {
		this.name = name;
		this.expId = expId;
	}

	public String getName() {
		return name;
	}

	public int getExpId() {
		return expId;
	}

	public List<RGInfo> getRgiList() {
		return rgiList;
	}

	public void addRGInfo(RGInfo rgi) {
		rgiList.add(rgi);
	}
	
	public void addPI(ProtocolInfo pi) {
		protocolList.add(pi);
	}
	
	public void addCEI(ColEquipInfo cei) {
		ceiList.add(cei);
	}
	public void addEnrolledSubject(EnrolledSubject es) {
		enrolledSubjects.add(es);
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("expId", expId);
		JSONArray arr = new JSONArray();
		for (RGInfo rgi : rgiList) {
			JSONObject child = rgi.toJSON();
			arr.put(child);
		}
		js.put("rgiList", arr);
		
		arr = new JSONArray();
		for(EnrolledSubject es : enrolledSubjects) {
			JSONObject child = es.toJSON();
			arr.put(child);
		}
		js.put("enrolledSubjects", arr);
		return js;
	}

	public static ExperimentInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		String name = js.getString("name");
		int expId = js.getInt("expId");

		ExperimentInfo ei = new ExperimentInfo(name, expId);
		JSONArray arr = js.getJSONArray("rgiList");
		for (int i = 0; i < arr.length(); i++) {
			JSONObject child = arr.getJSONObject(i);
			RGInfo rgi = RGInfo.initializeFromJSON(child);
			ei.addRGInfo(rgi);
		}
		arr = js.getJSONArray("enrolledSubjects");
		for (int i = 0; i < arr.length(); i++) {
			JSONObject child = arr.getJSONObject(i);
		   EnrolledSubject es = EnrolledSubject.initializeFromJSON(child);
		   ei.addEnrolledSubject(es);
		}
		return ei;
	}

	public List<EnrolledSubject> getEnrolledSubjects() {
		return enrolledSubjects;
	}

}