package clinical.web.vo.upload;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: HeaderFieldInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class HeaderFieldInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	String name;
	String value;
	String type;

	public HeaderFieldInfo(String name, String value, String type) {
		this.name = name;
		this.value = value;
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public String getValue() {
		return value;
	}

	public String getType() {
		return type;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("value", value);
		js.put("type", type);
		return js;
	}

	public static HeaderFieldInfo fromJSON(JSONObject js) throws JSONException {
		String name = js.getString("name");
		String value = js.getString("value");
		String type = js.getString("type");
		HeaderFieldInfo hfi = new HeaderFieldInfo(name, value, type);
		return hfi;
	}

}
