package clinical.web.workflow.cbf;

import java.io.File;

import org.apache.commons.logging.Log;

import clinical.utils.FileUtils;
import clinical.web.IAppConfigService;
import clinical.web.ServiceFactory;
import clinical.web.exception.BaseException;
import clinical.web.scheduler.JobInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CleanupUtils {
	private CleanupUtils() {
	}
	
	
	public static void cleanupWorkingDir(String curStatus, String cacheDir, Log log) {
		boolean doClean = true;
		if (curStatus == null) {
			doClean = false;
		} else {
			if (!curStatus.equals(JobInfo.CANCELED)
					&& !curStatus.equals(JobInfo.FINISHED)
					&& !curStatus.equals(JobInfo.FINISHED_WITH_ERR)
					&& !curStatus.equals(JobInfo.REMOVED)) {
				doClean = false;
			}
		}
		try {
			IAppConfigService configService = ServiceFactory
					.getAppConfigService();
			String value = configService.getParamValue("cbfbirn.clean.workdir");
			if (value != null && value.equalsIgnoreCase("false")) {
				doClean = false;
			}
		} catch (BaseException e) {
			log.error("cleanupWorkingDir", e);
		}
		if (doClean) {
			// String cacheDir = context.getCacheDir();
			log
					.info("removing temporary working directory contents (excluding download tarballs):"
							+ cacheDir);
			File wd = new File(cacheDir);
			File[] immediateChildren = wd.listFiles();
			for (File f : immediateChildren) {
				if (f.isDirectory()) {
					FileUtils.deleteRecursively(f);
				}
			}
		}
	}

	
}
