package clinical.web.workflow.cbf;

import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.Assertion;
import clinical.web.vo.upload.SegmentInfo;
import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SenseInfo.java 512 2012-01-14 02:04:26Z bozyurt $
 */
public class SenseInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	File pfile;
	String prefix;
	File outputDir;
	SegmentInfo pfileSI;
	// generated output
	List<File> senseOutBrikFiles = new ArrayList<File>(2);

	public SenseInfo(File pfile, String prefix, File outputDir,
			SegmentInfo pfileSI) {
		super();
		this.pfile = pfile;
		this.prefix = prefix;
		this.outputDir = outputDir;
		this.pfileSI = pfileSI;
	}

	public void replaceSenseOutBrikFiles(File tcatSenseOutBrikFile) {
		senseOutBrikFiles.clear();
		senseOutBrikFiles.add(tcatSenseOutBrikFile);
		String headFileName = tcatSenseOutBrikFile.getName();
		headFileName = headFileName.replaceFirst("\\.BRIK$", ".HEAD");
		File headFile = new File(tcatSenseOutBrikFile.getParent(), headFileName);
		Assertion.assertTrue(headFile.isFile());
		senseOutBrikFiles.add(headFile);
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONUtils.addJSONField("pfile", pfile, js);
		if (prefix != null) {
			js.put("prefix", prefix);
		}
		JSONUtils.addJSONField("outputDir", outputDir, js);
		JSONUtils.addJSONSI("pfileSI", pfileSI, js);
		JSONUtils.addJSONArray("senseOutBrikFiles", senseOutBrikFiles, js);
		return js;
	}

	public static SenseInfo initializeFromJSON(JSONObject js)
			throws JSONException, ParseException {
		File pfile = JSONUtils.getFile("pfile", js);
		File outputDir = JSONUtils.getFile("outputDir", js);
		String prefix = null;
		if (js.has("prefix")) {
			prefix = js.getString("prefix");
		}
		SegmentInfo pfileSI = JSONUtils.getSI("pfileSI", js);
		SenseInfo senseInfo = new SenseInfo(pfile, prefix, outputDir, pfileSI);

		senseInfo.senseOutBrikFiles = JSONUtils.getFiles("senseOutBrikFiles",
				js);
		return senseInfo;
	}

	public File getPfile() {
		return pfile;
	}

	public String getPrefix() {
		return prefix;
	}

	public File getOutputDir() {
		return outputDir;
	}

	public SegmentInfo getPfileSI() {
		return pfileSI;
	}

	public List<File> getSenseOutBrikFiles() {
		return senseOutBrikFiles;
	}

	public void addSenseOutBrikFile(File f) {
		this.senseOutBrikFiles.add(f);
	}

	public File getSenseOutBrikFile() {
		for (File f : senseOutBrikFiles) {
			if (f.getName().endsWith(".BRIK")) {
				return f;
			}
		}
		return null;
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("SenseInfo::[");
		sb.append("pfile:").append(pfile);
		sb.append(",prefix:").append(prefix);
		sb.append(']');
		return sb.toString();
	}
}
