package clinical.web.workflow.cbf;

import java.io.Serializable;
import java.text.ParseException;
import java.util.List;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: VisitProcessInfo.java 484 2011-11-15 00:29:07Z bozyurt $
 */
public class VisitProcessInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	List<CBFProcessInfo> cpiList;
	List<FieldMapInfo> fmList;
	List<SenseInfo> seList = new ArrayList<SenseInfo>(0);
	List<SiemensFieldMapInfo> siemensFmList;

	public VisitProcessInfo(List<CBFProcessInfo> cpiList,
			List<FieldMapInfo> fmList) {
		super();
		this.cpiList = cpiList;
		this.fmList = fmList;
	}

	public VisitProcessInfo(List<CBFProcessInfo> cpiList) {
		this.cpiList = cpiList;
	}

	public List<CBFProcessInfo> getCpiList() {
		return cpiList;
	}

	public List<FieldMapInfo> getFmList() {
		return fmList;
	}

	public List<SenseInfo> getSeList() {
		return seList;
	}

	public void setSeList(List<SenseInfo> seList) {
		this.seList = seList;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONArray arr = new JSONArray();
		if (cpiList != null) {
			for (CBFProcessInfo cpi : cpiList) {
				arr.put(cpi.toJSON());
			}
		}
		js.put("cpiList", arr);

		arr = new JSONArray();
		for (SenseInfo si : seList) {
			arr.put(si.toJSON());
		}
		js.put("seList", arr);
		arr = new JSONArray();
		if (fmList != null) {
			for (FieldMapInfo fmi : fmList) {
				arr.put(fmi.toJSON());
			}
		}
		js.put("fmList", arr);
		arr = new JSONArray();
		if (siemensFmList != null) {
			for (SiemensFieldMapInfo fmi : siemensFmList) {
				arr.put(fmi.toJSON());
			}
		}
		js.put("siemensFmList", arr);

		return js;
	}

	public static VisitProcessInfo initializeFromJSON(JSONObject js)
			throws JSONException, ParseException {
		JSONArray arr = js.getJSONArray("cpiList");
		List<CBFProcessInfo> cpiList = new ArrayList<CBFProcessInfo>(arr
				.length());
		for (int i = 0; i < arr.length(); i++) {
			CBFProcessInfo cpi = CBFProcessInfo.initializeFromJSON(arr
					.getJSONObject(i));
			cpiList.add(cpi);
		}

		arr = js.getJSONArray("fmList");
		List<FieldMapInfo> fmiList = new ArrayList<FieldMapInfo>(arr.length());
		for (int i = 0; i < arr.length(); i++) {
			FieldMapInfo fmi = FieldMapInfo.initializeFromJSON(arr
					.getJSONObject(i));
			fmiList.add(fmi);
		}

		VisitProcessInfo vpi = new VisitProcessInfo(cpiList, fmiList);

		arr = js.getJSONArray("seList");
		List<SenseInfo> seList = new ArrayList<SenseInfo>(arr.length());
		for (int i = 0; i < arr.length(); i++) {
			SenseInfo se = SenseInfo.initializeFromJSON(arr.getJSONObject(i));
			seList.add(se);
		}
		vpi.seList = seList;

		if (js.has("siemensFmList")) {
			arr = js.getJSONArray("siemensFmList");
			List<SiemensFieldMapInfo> siemensFmList = new ArrayList<SiemensFieldMapInfo>(
					arr.length());
			for (int i = 0; i < arr.length(); i++) {
				SiemensFieldMapInfo fmi = SiemensFieldMapInfo
						.initializeFromJSON(arr.getJSONObject(i));
				siemensFmList.add(fmi);
			}
			vpi.siemensFmList = siemensFmList;
		}
		return vpi;
	}

	public List<SiemensFieldMapInfo> getSiemensFmList() {
		return siemensFmList;
	}

	public void setSiemensFmList(List<SiemensFieldMapInfo> siemensFmList) {
		this.siemensFmList = siemensFmList;
	}
}
