package clinical.web.workflow.dti;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.vo.Deriveddata;
import clinical.utils.FileUtils;
import clinical.web.IDerivedImageDataService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.vo.DerivedDataInfo;
import clinical.web.vo.upload.SegmentInfo;
import clinical.web.vo.upload.SeriesHeaderInfo;
import clinical.web.vo.upload.VisitInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DTIProcJobHelper.java 750 2012-12-03 20:45:56Z bozyurt $
 */

@SuppressWarnings("unused")
public class DTIProcJobHelper {
	private DTIWFContext context;
	private IDerivedImageDataService didService;
	private UserInfo ui;
	
	private SegmentInfo fieldMap1SI;
	private SegmentInfo fieldMap2SI;
	private SegmentInfo dtiSI;
	private String templateDir;
	private String envPath;
	private Map<String, String> envMap = new HashMap<String, String>(17);
	private DTIWFProxy proxy;
	private static Log _log = LogFactory.getLog(DTIProcJobHelper.class);
	private final static boolean TEST_MODE = false;

	public DTIProcJobHelper(UserInfo ui, DTIWFContext context,
			String templateDir) throws BaseException {
		this.ui = ui;
		this.context = context;
		this.templateDir = templateDir;
		didService = ServiceFactory.getDerivedImageDataService(context
				.getDbID());
	}

	public DTIVisitProcessInfo prepare4Job() throws Exception {
		// TODO
		return null;
	}

	public List<Deriveddata> saveDerivedData(DTIVisitProcessInfo dvpi)
			throws Exception {
		List<DerivedDataInfo> ddiList = new ArrayList<DerivedDataInfo>();
		File rdRootFile = getRawDataRoot4Visit();
		File derivedDir = new File(rdRootFile, "derived_dti");
		derivedDir.mkdir();
		VisitInfo vi = context.getViList().get(0);
		String subjectID = vi.getSubjectID();
		int expId = vi.getExpId();
		int visitId = vi.getVisitId();

		// DTI processing derived data
		for (DTIProcessInfo dpi : dvpi.getDpiList()) {
			String dpiDirName = Utils.getPrefix(dpi, derivedDir);
			File dpiDerivedDir = new File(derivedDir, dpiDirName);
			dpiDerivedDir.mkdir();
			prepDD4DTISeries(dpi, dpiDerivedDir, subjectID, expId, visitId,
					ddiList);

		}
		return didService.addDerivedData(ui, ddiList);
	}

	protected void prepDD4DTISeries(DTIProcessInfo dpi, File derivedDir,
			String subjectID, int expId, int visitId,
			List<DerivedDataInfo> ddiList) throws IOException {

		for (File resultImgFile : dpi.getResultImageFiles()) {
			DerivedDataInfo iddi = prepDerivedDataInfo(expId, visitId,
					subjectID, dpi.getDtiSI(), resultImgFile);
			ddiList.add(iddi);
		}
	}

	protected DerivedDataInfo prepDerivedDataInfo(int expID, int visitID,
			String subjectID, SegmentInfo si, File derivedFile) {
		DerivedDataInfo ddi = new DerivedDataInfo();
		ddi.setExperimentID(expID);
		ddi.setVisitID(visitID);
		ddi.setSegmentID(si.getSegmentId());
		ddi.setSubjectID(subjectID);
		ddi.setBad(false);
		ddi.setDataURI(derivedFile.getAbsolutePath());
		return ddi;
	}

	protected File getRawDataRoot4Visit() {
		VisitInfo vi = this.context.getViList().get(0);
		List<String> imageFiles = new ArrayList<String>();
		for (SegmentInfo si : vi.getSiList()) {
			SeriesHeaderInfo shi = si.getShi();
			if (shi.getImages() != null && !shi.getImages().isEmpty()) {
				imageFiles.add(shi.getImages().get(0));
			}
		}

		String commonRoot = FileUtils.findCommonRoot(imageFiles);
		if (commonRoot == null)
			return null;
		return new File(commonRoot);
	}
}
