<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<link rel="stylesheet" type="text/css" href="layout/jquery-ui.css">
<link rel="stylesheet" type="text/css" href="yui/assets/skins/sam/skin.css">
<link rel="stylesheet" type="text/css" href="yui/assets/skins/sam/button.css">

<link rel=stylesheet
	href="<%=request.getContextPath()%>/pages/layout/cas.css" type="text/css">

<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/jquery-ui-1.10.2.js"></script>

<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/jquery.ba-tinypubsub.js""></script>

<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/cas.js"></script>

<style>
 #templates {
  display:none;
 }

 #delPanel {
    display:none;
 }

 #delPanel label {
    font-weight:bold;
 }
</style>


<script>

jQuery(function() {
      jQuery.post('<html:rewrite page="/atman.do"/>', 
            {action:'getAT'},
            function(data) {
               var aiList = data.aiList;
               if (aiList.length > 0) {
                   var asSelector$ = jQuery('.asChooser');
                   jQuery.populateSelect(asSelector$[0], aiList, function(o) {
                       return {name: o.name, value: o.id};
                   });
                   jQuery('#delPanel').show();
                   jQuery('#deleteAsEntry').click(function(event) {
                      var asId = jQuery(':selected',asSelector$).val();
                      var asRec = jQuery.grep(aiList, function(o) {
                         return o.id == asId;
                      })[0];
                      var ok = confirm("Do you want to delete the assessment '" + asRec.name + "'?");
                      if (ok) {
                        jQuery.post('<html:rewrite page="/atman.do"/>', 
                            {action:'deleteAT',asId:asId},
                            function(data) {
                                alert("The assessment '" + asRec.name + "' is deleted!");
                                var idx = jQuery.inArray(asRec, aiList);
                                aiList.splice(idx, 1);
                                if (aiList.length > 0) {
                                  jQuery.populateSelect(asSelector$[0], aiList, function(o) {
                                    return {name: o.name, value: o.id};
                                  });
                                } else {
                                   jQuery('#delPanel').hide();
                                }
                            }).fail(
                                function(xhr, textStatus, errThrown) {
                                  alert('Error:' + errThrown); }
                            );
                      }
                   });
               }
               if (data.name) {
                 alert("The assessment type '" + data.name + "' is saved!");
               } else if (data.error) {
                 alert("An error occured:" + data.error);
               }
         }).fail(
               function(xhr, textStatus, errThrown) {
                  alert('Error:' + errThrown);
         });


       var ab = new cas.AsBuilder([]);
       jQuery('#addScore').click(ab, function(event) {
           var newScore$ = jQuery('<div></div>').addClass('newScore').appendTo('#scoreBuildPanel');
           event.data.populateNewScore(newScore$);
       });

       jQuery('#createAs').click(ab, function(event) {
          event.preventDefault();
          var form$ = jQuery('#atmf'); 
          var at = event.data.createAssessment(jQuery('#caBuilder'), false);

          jQuery.post('<html:rewrite page="/atman.do"/>', 
            {action:'createAT', newAT:JSON.stringify(at)},
            function(data) {
               if (data.name) {
                 alert("The assessment type '" + data.name + "' is saved!");
               } else if (data.error) {
                 alert("An error occured:" + data.error);
               }
            }).fail(
               function(xhr, textStatus, errThrown) {
                  alert('Error:' + errThrown);
               }
            );

          //jQuery('input[name="newAT"]',form$).attr('value', JSON.stringify(at) );
          // form$.submit();
       });


       jQuery('body').on({
         ajaxStart: function() {
            jQuery(this).addClass("loading");
         },
         ajaxStop:  function() {
           jQuery(this).removeClass("loading");
         }
       });
});

</script>

<div class="error">
    <html:errors/>
</div>

<div id="creatorPane" class="mainPanel">
  <div class="headerPane">
      <div class="mlarge" style="margin:0 0 0 5px; padding:0;">Create New Assessment Type</div>
  </div>
 
  <div id="delPanel">
       <div class="input_div">
            <label for="asFilter">Assessment:</label>
            <select id="asFilter" name="asFilter" class="asChooser" title="Select an assessment">
            </select>
            &nbsp;
            <button id="deleteAsEntry" type="button" class="submit-button">Delete</button>
       </div>
  </div>
<html:form action="/atman" styleId="atmf"> 
   <input type="hidden" name="action" value="createAT" />
   <input type="hidden" name="newAT" value=""/>

    <div id="caBuilder" style="margin-top:5px;">
      <fieldset id="cabPane" style="margin-left:5px; padding-top:5px;">
        <legend>Clinical Assessment Builder</legend>
        <div class="input_div"> 
            <label class="label1" for="asName">Name:</label>
            <input type="text" id="asName" name="asName" placeholder="Assessment Name" value="" />
        </div>
        <div class="input_div"> 
            <label class="label1" for="asDesc">Description:</label>
            <textarea id="asDesc" name="asDesc" 
                 placeholder="A description for the assessment" cols="30" rows="3"></textarea>
        </div>
        <div class="buttonBar">
             <button type="button" id="addScore" class="submit-button">Add Score</button>
             <button type="button" id="createAs" class="submit-button">Create Assessment</button>
        </div>
        <div id="scoreBuildPanel">
        </div>
        
     </fieldset>
    </div>
</html:form>
</div>

<div class="modal"></div>

<div id="templates">
     <div class="template protocolChooser">
        <select name="pChooser" title="Select the Series Type">
        </select>
     </div>
     <div class="template seriesTimestamp">
          <input name="timestamp" type="text" size="16">
     </div>

      <div class="template scoreRemover">
           <button type="button" class="scoreRemover"
            title="Remove this score"></button>
      </div>
      <div class="template sfbuild">
          <label>Score:</label>
          <input type="text" name="scoreName" value=""/>
          &nbsp;
          <label>Score Type:</label>
          <select name="scoreTypeSel" title="Select a score type">
               <option value="varchar" selected="selected">String</option>
               <option value="integer">Integer</option>
               <option value="float">Real</option>
          <%--     <option value="timestamp">Date</option>
               <option value="boolean">Boolean</option>
           --%>
          </select>
      </div>
      
      <div class="template string">
           <label></label>
           <input type="text" name="score" value=""/>
      </div> 
      <div class="template numeric">
         <label></label>
        <input type="text" name="score" class="numeric"/> 
      </div>

     <div class="template boolean">
         <label></label>
        <input type="radio" name="score" value="yes" checked="checked"/> <span>Yes</span>
        <input type="radio" name="score" value="no"/> <span>No</span>
      </div>
      <div class="template date">
         <label></label>
           <input type="text" name="score"/> 
      </div>

</div>
 
</div>

<script>
     var divElem = jQuery('#creatorPane')[0];
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
</script>
