<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean"%>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html"%>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core"%>


<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/yahoo-dom-event/yahoo-dom-event.js"></script>
<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/element/element-min.js"></script>
<script language='javascript'
	src='<%=request.getContextPath()%>/pages/validator.js'></script>

<script language='javascript'>
  
  var exp2ViListMap = null;

  function onLoadHandler() {
	  exp2ViListMap = <c:out value="${cjmForm.exp2ViListJSON}" escapeXml="false" />;
	  handleViListPopulation();
  }

  function handleViListPopulation() {
	  var expSelector = document.getElementById('expSelector');
	  if (!expSelector) return;
	  var viSelector = document.getElementById('viSelector');
	  var selExpId = expSelector.options[ expSelector.selectedIndex].value; 
	  var vilInfo = exp2ViListMap[selExpId];
	  if (!vilInfo) return;
	  var viList = vilInfo.viList;
	  viSelector.options.length = 0;
	  for(var i = 0; i < viList.length; i++) {
		  var option = new Option( viList[i].label, viList[i].id);
		  try {
			  viSelector.add(option,null);
		  } catch(e) {
			  viSelector.add(option,-1);
		  }
	  }
	  jQuery("#reg_rb")[0].disabled=true;
	  jQuery("#acs_cb")[0].disabled=true;
	  jQuery("#pvc_rb")[0].disabled=true;
	  onVisitChange(viSelector);
  }

  function validate() {
	  var viSelector = document.getElementById('viSelector');
	  if (!viSelector) return false;
	  var count = 0;
	  for(var i = 0; i < viSelector.options.length; i++) {
		  if (viSelector.options[i].selected) {
			  count++;
		  }
	  }
	  if (count == 0) {
		  alert("At least a series needs to be selected for job submission!");
		  return false;
	  }
	  return true;
  }

  function changeTab(form) {
	  form.submit();
	  return false;
  }

  function onVisitChange(selector) {
	  var expSelector = document.getElementById('expSelector');
	  var selExpId = expSelector.options[ expSelector.selectedIndex].value; 
	  var vilInfo = exp2ViListMap[selExpId];
	  if (!vilInfo) return;
	  var viList = vilInfo.viList;
     var vi = viList[selector.selectedIndex];
     jQuery('#lt_cb')[0].checked = false;
      if (vi.scanner && vi.scanner == "Siemens") {
          jQuery("#sense_rb")[0].disabled=true;
          jQuery("#acs_cb")[0].disabled=false;
          jQuery("#pvc_rb")[0].disabled=false;
      } else {
     	  jQuery("#sense_rb")[0].disabled=false;
     	  if (vi.hasAnat) {
         	 jQuery("#acs_cb")[0].disabled=false;
         	 jQuery("#acs_cb")[0].checked=false;
         	 jQuery("#pvc_rb")[0].disabled=false;
     	  } else {
     		 jQuery("#acs_cb")[0].checked=false;
      		 jQuery("#acs_cb")[0].disabled=true;
     		 jQuery("#pvc_rb")[0].disabled=true;
     	  }
     	  if (vi.hasFM) {
     		 jQuery("#fmc_rb")[0].disabled=false;
     	  } else {
     		 jQuery("#fmc_rb")[0].disabled=true;
         	 jQuery("#fmc_rb")[0].checked=false; 	  
     	  }
      }   
  }

 	  
  YAHOO.util.Event.onDOMReady(function() {
     var Dom = YAHOO.util.Dom, Event = YAHOO.util.Event;

     jQuery("#reg_rb")[0].disabled=true;
     jQuery("#acs_cb")[0].disabled=true;
     jQuery("#pvc_rb")[0].disabled=true;

     Event.on("fmc_rb", "click" , function(ev) {
         jQuery("#reg_rb")[0].disabled=false;
     });
     Event.on("def_rb", "click", function(ev) {   
          jQuery("#reg_rb")[0].disabled=true; });
     Event.on("sense_rb", "click", function(ev) {  
      jQuery("#reg_rb")[0].disabled=true; });

    Event.on("lt_cb", "click", function(ev) {
       var auto_cb$ = jQuery('#acs_cb');
       var csf_rbg$ = jQuery('input[name="csfMethod"]');
       var checked = jQuery(this).prop("checked");
       auto_cb$.prop("disabled",checked);
       csf_rbg$.prop("disabled",checked);
    });

    Event.on("acs_cb","click", function(ev) {
        var lt_cb$ = jQuery('#lt_cb');
        lt_cb$.prop("disabled", jQuery(this).prop("checked"));
    });

	 Event.on("cjf", "submit", function(ev) {
		  var ok = validateIfSiemensAppropriate();
		  if (!ok || !validateThresh() || !validateFWHM() ) {
			  Event.preventDefault(ev);
		  } 
	  });
	 Event.on("viSelector","change", function(ev) { 
      onVisitChange( jQuery("#viSelector")[0]); });
	 Event.on("expSelector","change", function(ev) { handleViListPopulation(); });
	 
     onLoadHandler();
     var validateThresh = function() {
          var field = Dom.get('gmt');
			 if (field.value.length == 0) {
			    alert("A gray matter threshold value needs to be specified!");
				 return false;
			 }
			 if (!clinical.isNumber(field.value) ) {
			    alert("Gray matter threshold must be a number!");
				 return false;
			} else {
			  if (field.value < 0.5 || field.value > 1.0) {
			    alert("Gray matter threshold value must in in range [0.5-1.0]!");
				 return false;
			  }
			}
         return true;  
     };

     var validateFWHM = function() {
    	 var field = Dom.get('fwhm');
		 if (field.value.length == 0) {
              field.value = 0;
		 } else {
			 if (!clinical.isNumber(field.value) ) {
                  alert("Smoothing parameter must be a real number!");
                  return false;   
			 } else {
				 if (field.value < 0 || field.value > 10.0) {
					 alert("Smoothing parameter value must in in range [0 - 10.0]!");
				     return false;
				 }
			 }
		 } 
		 return true;
     };

     var validateIfSiemensAppropriate = function() {
   	  var expSelector = jQuery('#expSelector')[0];
   	  var selExpId = expSelector.options[ expSelector.selectedIndex].value; 
   	  var vilInfo = exp2ViListMap[selExpId], 
             viList, selector, vi;
   	  if (!vilInfo) return true;
   	  viList = vilInfo.viList;
   	  selector = jQuery("#viSelector")[0];
   	  if (!selector) return true;
         vi = viList[selector.selectedIndex];
         if (vi.scanner && vi.scanner == "Siemens") {
        	// Siemens manual segmentation is now supported (5/29/2012) 
           /*	
            if ($("acs_cb").checked == false) {
           	   alert("For Siemens, only automatic CBF segmentation is supported!");
       		   return false;
       	    }
         	*/   
         }
         return true;
     };
     
  });
</script>

<div class="error"><html:errors /></div>

<%--
<html:form action="/dtijobman" styleId="djf">
	<input type="hidden" name="action" value="view" />
</html:form>
--%>

<html:form action="/postprocjobman" styleId="ppjf">
	<input type="hidden" name="action" value="view" />
</html:form>

<div id="tabpanel">
<ul id="tabs">
	<li class="activelink"><a href="#">ASL</a></li>
	<%-- <li><a href='javascript:{}' onclick="changeTab($('djf'));">DTI</a></li> --%>
	<li><a href='javascript:{}' onclick="changeTab(jQuery('#ppjf')[0]);">Group Analysis</a></li>
</ul>
</div>
<html:form action="/cbfjobman" styleId="cjf">
	<input type="hidden" name="action" value="submitJob" />

	<div id="jobManPane" class="mainPanel">
	<div class="headerPane">
	<div class="mlarge" style="margin: 0 0 0 5px; padding: 0;">CBF
	Job Submission</div>
	</div>
	<c:if test="${cjmForm.hasData == true}">

		<div class="input_div"><label><span class="label"
			title="Name of the project/experiment">Experiment:</span></label> <bean:define
			id="expList" name="cjmForm" property="expSelector.experimentInfos"
			type="java.util.Collection" /> 
			<html:select styleId="expSelector"
			name="cjmForm" property="expSelector.selectedExpID"
			onchange="handleViListPopulation();">
			<html:options collection="expList" property="value"
				labelProperty="label" />
		</html:select>
		</div>
		<div class="input_div"><label><span class="label"
			title="Series for processing (Subject ID  Visit Date)">Series:</span></label>
		<select id="viSelector" name="viSelector">
		</select></div>
		
		
		
		<div class="input_div">
		<div style="font-weight: bold">Preprocessing</div>
		</div>
		<div class="input_div"><c:if
			test="${not cjmForm.doFieldMapCorrection and not cjmForm.doSense }">
			<input id="def_rb" type="radio" name="preproc" value="default"
				checked>
		</c:if> <c:if test="${cjmForm.doFieldMapCorrection or cjmForm.doSense }">
			<input id="def_rb" type="radio" name="preproc" value="default">
		</c:if> No Correction</div>
		<div class="input_div"><c:if
			test="${cjmForm.doFieldMapCorrection}">
			<input id="fmc_rb" type="radio" name="preproc"
				value="doFieldMapCorrection" checked>
		</c:if> <c:if test="${not cjmForm.doFieldMapCorrection}">
			<input id="fmc_rb" type="radio" name="preproc"
				value="doFieldMapCorrection" />
		</c:if> Field Map Correction
		<div id="fmc" style="margin-left: 2em; padding: 5px;">
		Registration 
        <c:if test="${cjmForm.doReg}">
			<input id="reg_rb" type="checkbox" name="doReg" checked>
		  </c:if> 
        <c:if test="${not cjmForm.doReg}">
			<input id="reg_rb" type="checkbox" name="doReg" />
		</c:if>
       </div>
		</div>
		<div class="input_div"><c:if test="${cjmForm.doSense}">
			<input id="sense_rb" type="radio" name="preproc" value="doSense"
				checked>
		</c:if> 
       <c:if test="${not cjmForm.doSense}">
			<input id="sense_rb" type="radio" name="preproc" value="doSense">
		</c:if> SENSE</div>

      <div class="input_div">
        <div style="font-weight: bold">CBF Calibration</div>
        
        <div class="input_div">Automatic CSF Segmentation 
          <c:if test="${cjmForm.useAutomatedSegmentation}">
			<input id="acs_cb" type="checkbox" name="doAutoCSF" checked>
		  </c:if> 
		  <c:if test="${not cjmForm.useAutomatedSegmentation}">
			<input id="acs_cb" type="checkbox" name="doAutoCSF" />
		  </c:if>
		</div>
        
        <div class="input_div">
          CSF Method: &nbsp;
          <c:if test="${cjmForm.csfMethod == 2}">
			   <input id="csfm_rb" type="radio" name="csfMethod" value="2" checked>
          </c:if>
          <c:if test="${cjmForm.csfMethod != 2}">
			   <input id="csfm_rb" type="radio" name="csfMethod" value="2">
          </c:if>
          Partial Volume &nbsp;
          <c:if test="${cjmForm.csfMethod == 1}">
			   <input id="csfm_rb" type="radio" name="csfMethod" value="1" checked>
          </c:if>
          <c:if test="${cjmForm.csfMethod != 1}">
			   <input id="csfm_rb" type="radio" name="csfMethod" value="1">
          </c:if>
          Top 5 &nbsp;
          <c:if test="${cjmForm.csfMethod == 0}">
			   <input id="csfm_rb" type="radio" name="csfMethod" value="0" checked>
          </c:if>
          <c:if test="${cjmForm.csfMethod != 0}">
			   <input id="csfm_rb" type="radio" name="csfMethod" value="0">
          </c:if>
          Automatic
        </div>
        <div class="input_div" id="lt">
		   Local Tissue Method
		   <c:if test="${cjmForm.useLTMethod}">
			 <input id="lt_cb" type="checkbox" name="ltMethod" checked>
		   </c:if> 
		   <c:if test="${not cjmForm.useLTMethod}">
			<input id="lt_cb" type="checkbox" name="ltMethod" />
		   </c:if>
		</div>
      </div>

      <div class="input_div">
		  <div style="font-weight: bold">Registration of anatomical to ASL</div>
        <div class="input_div">
        <c:if test="${cjmForm.alignment == 0}">
			  <input id="align_rb" type="radio" name="align" value="0" checked>
        </c:if>
        <c:if test="${cjmForm.alignment != 0}">
			  <input id="align_rb" type="radio" name="align" value="0">
        </c:if>
        No Alignment
        </div>
        <div class="input_div">
        <c:if test="${cjmForm.alignment == 1}">
			  <input id="align_rb" type="radio" name="align" value="1" checked>
        </c:if>
        <c:if test="${cjmForm.alignment != 1}">
			  <input id="align_rb" type="radio" name="align" value="1">
        </c:if>
         Use 3dAllineate and register to ASL Brik
        </div>
        <div class="input_div">
        <c:if test="${cjmForm.alignment == 2}">
			  <input id="align_rb" type="radio" name="align" value="2" checked>
        </c:if>
        <c:if test="${cjmForm.alignment != 2}">
			  <input id="align_rb" type="radio" name="align" value="2">
        </c:if>
        Use 3dAllineate and register to CSF Brik
        </div>
        <div class="input_div">
        <c:if test="${cjmForm.alignment == 3}">
			  <input id="align_rb" type="radio" name="align" value="3" checked>
        </c:if>
        <c:if test="${cjmForm.alignment != 3}">
			  <input id="align_rb" type="radio" name="align" value="3">
        </c:if>
         Use align_epi_anat.py script and register to CSF Brik
        </div>


      </div>
		<div class="input_div">
		  <div style="font-weight: bold">Post Processing</div>
		  <div class="input_div" id="pvc">
		   Partial Volume Correction 
		   <c:if test="${cjmForm.doPartialVolumeCorrection}">
			  <input id="pvc_rb" type="checkbox" name="doPVC" checked>
		   </c:if> 
		   <c:if test="${not cjmForm.doPartialVolumeCorrection}">
			 <input id="pvc_rb" type="checkbox" name="doPVC" />
		   </c:if>
		  </div>
		  <div class="input_div">
		   <label>Gray Matter Threshold [0.5-1.0]:</label> 
		   <html:text name="cjmForm" property="gmThreshold" styleId="gmt"
			  size="6" />
		  </div>
		  <div class="input_div">Skull Stripping 
		    <c:if test="${cjmForm.doSkullStripping}">
			  <input type="checkbox" name="doSkullStripping" checked>
		    </c:if> 
		    <c:if test="${not cjmForm.doSkullStripping}">
			  <input type="checkbox" name="doSkullStripping" />
		    </c:if>
		  </div>
		  <div class="input_div">
		    <label>Smoothing (FWHM) Parameter [0 - 10.0]:</label>
		    <html:text name="cjmForm" property="gaussianFilterParam" styleId="fwhm"
			  size="6" />
		  </div>
		</div>
		<div class="button_div"><input type="submit"
			class="submit-button" value="Submit Job" id="viSelButton"
			onclick="return validate();" />
		</div>
	</c:if> <c:if test="${not cjmForm.hasData}">
		<div class="input_div"><span
			style="color: red; font-weight: bold;"> No data is available
		for CBF processing! </span></div>
	</c:if></div>
</html:form>

<script>
     var divElem = jQuery('#jobManPane')[0];
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
     var tabs = jQuery('#tabs li');
     tabs.each(
         function() { 
            Rico.Corner.round( jQuery(this)[0],  {color: "#00659c", corners: 'top'}); }
      );
</script>

