<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>

<script type="text/javascript">

 function go(elem, actionValue) {
     elem.form.action.value =actionValue;
     onSubmitHandler(elem.form);
 }

 function go2(elem, actionValue) {
     elem.form.action.value =actionValue;
 }
 
 function append2List(list, items) {
    for(var i = 0; i < items.length; i++) {
    	list[list.length] = items[i];	
    }
 }
 
 function onSubmitHandler(form) {
    var list = new Array();
   <c:forEach var="item" items="${scForm.items}">
    append2List(list, <c:out value="${item.treeId}"/>.getSelectedTitles() );
   </c:forEach>
    var str = "<list>";
    for(var i = 0; i < list.length; i++) {
       // alert("list["+ i + "].type=" + list[i].type); 
       if (list[i].type == 'ca') {
         str += "<ca>" + list[i].path + "</ca>";
       } else {
         str += "<item>" + list[i].path + "</item>";
       }
    }
    str += "</list>";
    form.results.value = str;
 }
 
 function removeItem(elem, subjectID) {
    elem.form.action.value = 'removeItem';
    elem.form.subjectID.value = subjectID;
    elem.form.submit();
    return false;
 }
 
 // global var 
 var totalSize = 0;
 
 function totalSizeHandler(checkedList, uncheckedList) {
     if ( uncheckedList) {
        // alert("uncheckedList:" + uncheckedList.length );
        
        for(var i = 0; i < uncheckedList.length; ++i) {
           var payload = uncheckedList[i].payload;
           if ( payload && !uncheckedList[i].hasChild) {
              totalSize -= payload;
           }
        }
     }
     if ( checkedList) {
        //alert("checkedList:" + checkedList.length );
        for(var i = 0; i < checkedList.length; ++i) {
           var payload = checkedList[i].payload;
           if ( payload && !checkedList[i].hasChild) {
              totalSize += payload;
           }
        }
     }
     var el = $('size-div');
     if ( el ) {
        str = "Download size : " + utils.formatFileSize(totalSize);
        el.innerHTML=str;
     }
 }
</script>

<style>
#sc_mainPanel {
   float:left;
   width:90%; 
}
</style>

<div class="error">
  <html:errors/>
</div>
<form method="post" action="<c:url value="/cart.do"/>">
 <input type="hidden" name="action" value=""></input>
<input type="hidden" name="results" value=""></input>
<input type="hidden" name="subjectID" value=""></input>

<div id="sc_mainPanel"> 
 <table border="0" cellspacing="0" bgcolor="#d3d3d3" class="tablelist">
 <tr bgcolor="#00659c">
   <td colspan="2" align="center">
     <span style="color:white; font-weight:bold; font-size:12pt;">Shopping Cart Contents </span>
   </td>
 </tr>
 <tr>
   <td colspan="2">
     <div style="color:maroon; margin:5px;">Please provide a name for your download bundle and 
     select the files you want to be included.</div>
   </td>
 </tr>
 <tr height="35px" >
  <td colspan="2">
     <span style="font-weight:bold" >Bundle Name:</span>
     <html:text name="scForm" property="bundleName" /><span style="color:red;font-size:11px; vertical-align:bottom;"> *</span>
  </td>
 </tr>
 <c:if test="${scForm.supportEmail}">
     <tr>
       <td colspan="2">
         <div style="border:1px dotted #2f4f4f; padding:0.5em; padding-right:1em;">
           <div style="padding-top:2px; padding-bottom:2px;">
            <html:checkbox name="scForm" property="notifyByEmail">&nbsp;Email Notification</html:checkbox>
           </div>
           <div style="padding-top:2px; padding-bottom:2px;">  
            <span style="font-weight:bold" >Notification email:</span>&nbsp;<html:text name="scForm" property="email" />
           </div> 
         </div>
     </td>
     </tr>
     </c:if>
  <tr>
  <td  colspan="2">
     <div id="size-div" style="margin:2px; padding:3px;">
     </div>
  </td>
 </tr>
 <c:if test="${scForm.allEmpty}" >
 <tr>
    <td colspan="2"> 
     <div id="warning-div" style="margin:2px; padding:3px;">
         <span style="color:red; font-weight: bold;">No matching image data has been found!</span> 
     </div>
    </td>
 </tr>
 </c:if>
   <c:forEach var="item" items="${scForm.items}">
     <tr>
        <td>
          <div id='item_<c:out value="${item.treeId}"/>' >
          <script type="text/javascript">
             <c:out value="${item.javascriptTree}" escapeXml="false"/>        
          </script>
          </div>  
	</td>
	<td width="50px" align="top">
    	<button onclick="return removeItem(this,'<c:out value="${item.subjectID}"/>');"><img src="<%=request.getContextPath()%>/pages/images/remove.png" ></button>
	</td>
     </tr>
   </c:forEach>
  <tr>
    <td colspan="2" align="right">
       <input type="submit" class="submit-button" value="Back to Search Results" onclick="go2(this,'Back')"></input>
       &nbsp;
       <input type="submit" class="submit-button" value="Schedule Download" onclick="go(this,'scheduleDownload')"></input>
    </td>
  </tr>
 </table>
</div> 
</form>
