<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>

<script language='javascript' src='<%=request.getContextPath()%>/pages/popcalendar.js'></script>
<script language='javascript' src='<%=request.getContextPath()%>/pages/validator.js'></script>

<script>
   function go(elem, actionValue) {
    elem.form.action.value =actionValue;
  }

  function validate(form) {
     var valMsg = "Please correct the following validation error(s):\n\n";
     var foundErrors = false;
     var nameElemMap = clinical.convertToElementMap(form);
     var studyTimeElem = nameElemMap["currentStudy.time"];
     if ( studyTimeElem.value.length > 0) {
       if ( clinical.validateTime(studyTimeElem.value) === false) {
          foundErrors = true;
          valMsg += "Study Time is not valid! It should be in 'hh:mm' format!\n";
       }
     }
     if (foundErrors) {
       alert(valMsg);
       return false;
     }
     return true;
  }
</script>

<div class="error">
   <html:errors/>
</div>
<br>
<br>

<html:form action="/subjectman" onsubmit="return validate(this);">
<center>
<table border="0" cellspacing="0" cellpadding="2" bgcolor="#00659" width="80%">
 <html:hidden name="svmForm" property="selectedVisitID"/>
 <html:hidden name="svmForm" property="selectedStudyID"/>
 <input type="hidden" name="action" value=""/>

<%-- in case user tries to edit the default study --%>
<logic:equal name="svmForm" property="currentAction" value="edit_study">
<logic:empty name="svmForm" property="currentStudy">
 <tr>
  <td>
    <table border="0" cellspacing="0" width="100%" bgcolor="white">
     <tr bgcolor="#d3d3d3">
      <td class="header">Study Management</td>
     </tr>
     <tr> <td> <span class="warn"><b>Default Study is not editable!<b></span> </td> </tr>
     <tr> <td> Please use your browsers' Back button to go back and retry after selecting a valid study!</td> </tr>
    </table>
  </td>
 </tr> 
</logic:empty>
</logic:equal>

<logic:notEmpty name="svmForm" property="currentStudy">
<%-- subject summary section --%>
<tr>
  <td>
    <table border="0" cellspacing="0" width="100%" bgcolor="white">
     <tr bgcolor="#d3d3d3">
      <td class="header" colspan="2" >Study Management</td>
     </tr>
     <tr>
       <td><b>Subject ID:</b>&nbsp;
          <bean:write name="svmForm" property="subject.subjectID"/>
        </td>
        <td>
          <table border="0" cellspacing="0" width="100%" bgcolor="white">
            <tr>
              <td><b>Experiment:</b></td>
              <td> <bean:write name="svmForm"  property="currentVisit.experiment"/></td>
            </tr>

            <tr>
              <td><b>Visit:</b></td>
              <td> <bean:write name="svmForm" property="visitDateValue"/> </td>
            </tr>
            <tr><td>&nbsp;</td></tr>
          </table>
        </td>
     </tr>
    </table>
  </td>
</tr>
<%-- study section --%>
<tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0" width="100%" bgcolor="white">

<logic:notEmpty name="svmForm" property="currentVisit.studyFormInfos">
    <tr  bgcolor="#d3d3d3" >
               <td colspan="2" class="header">Study&nbsp;</td>
     </tr>
 </logic:notEmpty>

   <tr>
    <td colspan="2">
       <table border="0" cellspacing="0" cellpadding="0" width="100%" bgcolor="white">
         <logic:equal name="svmForm" property="currentAction" value="edit_study">
           <tr>
              <td colspan="6"><b>Segment ID:</b>&nbsp;
		     <bean:write name="svmForm"
                       property="currentStudy.study.studyID" />
               </td>
           </tr>
          </logic:equal>

           <tr>
               <td><b>Date:</b></td>
              <td> <bean:write name="svmForm" property="currentStudy.date"/></td>
               <td><b>Time:</b></td>
               <td> <html:text name="svmForm" property="currentStudy.time"/></td>
               <td>&nbsp;</td>
               <td> &nbsp; 
               </td>
           </tr>
           <tr>
               <td><b>Name:</b></td>
               <td><html:text name="svmForm" property="currentStudy.name" /></td>
               <td> &nbsp;</td>
               <td> &nbsp;</td>
           </tr>
           <tr>
             <td><b>Description:</b></td>
              <td colspan="4">
                 <html:textarea name="svmForm" property="currentStudy.description" cols="60" rows="3"/>
              </td>
              <td>&nbsp; </td>
           </tr>
           <tr><td colspan="2">&nbsp;</td></tr>
        </table>
        <!-- study table -->
     </td>
   </tr>

  </td>
 </tr>
 </table>

 </td>
 </tr>
 <logic:equal name="svmForm" property="currentAction" value="add_study">
 <tr>
   <td>
     <%-- segments section --%>
       <table border="0" cellspacing="0" width="100%" bgcolor="white">
           <tr bgcolor="#d3d3d3">
             <td class="header" colspan="2">Segments</td>
           </tr>
           <logic:iterate id="sfi" name="svmForm" property="currentStudy.segmentFormInfos" indexId="idx">
            <tr>
               <td colspan="2">&nbsp;</td>
            </tr>
           <tr><td colspan="2"> 
             <table border="0" cellspacing="0" cellpadding="0" width="100%">
               <tr>
                 <logic:equal name="svmForm" property="currentAction" value="add_study">
                    <td colspan="6">&nbsp;</td>
                 </logic:equal>
                 <logic:equal name="svmForm" property="currentAction" value="edit_study">
                       <td colspan="6"><b>Segment ID:</b>&nbsp;
		          <bean:write name="sfi" property="studySegment.segmentID" />
                       </td>
                 </logic:equal>
                </tr>
                <tr>
                  <td><b>Date:</b></td>
                    <td nowrap> <html:text name="sfi" property="date" indexed="true"/>
                      <input type=button
                             onclick='popUpCalendar(this, findElement(this.form,"<%= "sfi[" + idx +"].date"%>"),
                                   "mm/dd/yyyy")' value='...' style='font-size:11px'>

                    </td>
                    <td><b>Time (hh:mm):</b></td>
                    <td> <html:text name="sfi" property="time" indexed="true" /></td>
                    <td> &nbsp; </td>
                    <td> &nbsp; </td>
                </tr>
                <tr>
                  <td><b>Name:</b></td>
                   <td> <html:text name="sfi" property="name" indexed="true" /> </td>               
                   <bean:define id="protocols" name="sfi" property="protocols"
                           type="java.util.Collection"/>
                   <td><b>Protocol:</b></td>
                   <td> <html:select name="sfi" property="protocolValue" indexed="true">
                          <html:options collection="protocols" property="value" labelProperty="label"/>
                         </html:select>
                   </td>
                   <td> &nbsp; </td>
                   <td> &nbsp; </td>
                </tr>
                <tr>
                  <td><b>Description:</b></td>
                  <td colspan="4">
                         <html:textarea name="sfi" property="description" cols="60" rows="3" indexed="true"/>
                  </td>
                  <td>&nbsp;</td>
                </tr>

                
             </table>
             <!-- segment table -->
           </td>
          </tr>
         </logic:iterate>
         
       </table>
   </td>
 </tr>
 </logic:equal>
  <tr>
      <td colspan="2" align="right">
        <logic:equal name="svmForm" property="currentAction" value="edit_study">
           <%-- button.study_edit --%>
           <html:submit styleClass="submit-button" onclick="go(this,'Edit Study')" >Save</html:submit>
        </logic:equal>
        <logic:equal name="svmForm" property="currentAction" value="add_study">
            <html:submit styleClass="submit-button" onclick="go(this,'Add Study')" >
              <bean:message key="button.study_add"/></html:submit>
        </logic:equal>
      </td>
  </tr>  
<%-- there is a currentStudy --%>
</logic:notEmpty>

</table>

</center>
</html:form>
