var cas = cas || {};

cas.AsBuilder = function(caMeta) {
   this.caMeta = caMeta;
   this.scoreCount = 0;
   jQuery('button.scoreRemover').live('click', function() {
         jQuery(this).closest('div.newScore').remove();
         });
   jQuery('.newScore [name]').live('suffixName', function() {
         var $wr = jQuery(this),
         suffix = $wr.closest('.newScore').data('suffix');
         if (/\w+\.\d+$/.test($wr.attr('name')) ) { return; }
         $wr.attr('name', $wr.attr('name') + suffix);
         });
   jQuery.subscribe("show", this.reset);
};

cas.AsBuilder.prototype.populateNewScore = function(container) {
   var $cwr = jQuery(container);
   jQuery('div.template.scoreRemover').children().clone().appendTo($cwr);
   $cwr.data('suffix', '.' + this.scoreCount++);
   jQuery('div.template.sfbuild').children().clone().appendTo($cwr);
   $cwr.children().trigger('suffixName');
};


cas.AsBuilder.prototype.reset = function() {
   jQuery('#scoreBuildPanel').children().remove();
   jQuery('#asName').attr('value','');
   jQuery('#asDesc').attr('value','');
};

cas.AsBuilder.prototype.validate=function(container) {
   var $cwr = jQuery(container);
   var errMsg = '', emptyScoreNameCnt = 0;
   jQuery('input[name^="scoreName"]', $cwr).each(function() {
         var scoreName = jQuery(this).attr('value');
         scoreName = jQuery.trim();
         if (scoreName.length === 0) {
         emptyScoreNameCnt++;
         }
         });
   if (emptyScoreNameCnt > 0) {
      errMsg += "All scores need to have a name!";
   }
   return errMsg;
};

cas.AsBuilder.prototype.createAssessment = function(container, submitViaAjax) {
   var $cwr = jQuery(container);
   var at = {name:'', descr:''};
   at.name = jQuery.trim(jQuery('input[name="asName"]', $cwr).val());
   at.descr = jQuery.trim(jQuery('#asDesc', $cwr).val());
   at.scores = [];
   if (at.descr.length == 0) { at.descr = at.name; }
   jQuery('input[name^="scoreName"]', $cwr).each(function() {
         var scoreName = jQuery(this).attr('value');
         var scoreType = jQuery(this).siblings('select[name^="scoreTypeSel"]').val();
         var st = {name: scoreName, type: scoreType, descr:'', possibleValues:[] };
         at.scores.push(st);
         });

   if (!submitViaAjax) {
      return at;
   }
   // alert( JSON.stringify(at));
   jQuery.post('saveAT', {action:"", at:at}, 
         function(data) {
           alert(data.message);
           if (data.asiList) {
              asiList = data.asiList;
              jQuery.publish("asListChanged", [data.asiList]);
           }
           jQuery('#caBuilder').hide();
           jQuery('#caEntry').show();
         }, 'json').fail(
            function(xhr, textStatus, errThrown) { 
             alert('Error:' + textStatus); 
        });
};

cas.AsEntryManager = function(asList) {
   this.asList = asList;
   this.scoreCount = 0;

   var $asSelector = jQuery('.asChooser');
   jQuery.populateSelect($asSelector[0], this.asList, function(o) {
         return { name: o.name, value: o.asId};   
         });
   var that = this;
   var newAsHandler = function(event, atList) {
      that.asList = atList;
      var $asSelector = jQuery('.asChooser');
      jQuery.populateSelect($asSelector[0], atList, function(o) {
            return { name: o.name, value: o.asId};   
            });
   }
   jQuery.subscribe("asListChanged", newAsHandler);

   jQuery('.score [name]').live('suffixName', function() {
         var $wr = jQuery(this),
         suffix = $wr.closest('.score').data('suffix');
         if (/\w+\.\d+$/.test($wr.attr('name')) ) { return; }
         $wr.attr('name', $wr.attr('name') + suffix);
         });

   jQuery($asSelector).live('change', this, function(event) {
         var i, asId = jQuery(':selected', this).val();
         var maxScoreLen = -1;
         var asRec = jQuery.grep(event.data.asList, function(o) {
            return o.asId == asId;
            })[0];
         jQuery('#asEntryPanel').children().remove();
         for(i = 0; i < asRec.scores.length; i++) {
            var $wr = jQuery('<div></div>').addClass('score').appendTo('#asEntryPanel');
            $wr.data('suffix','.' + event.data.scoreCount++);
            event.data.prepScoreEntry($wr, asRec.scores[i].name, 
                  asRec.scores[i].type); 
            $wr.children().trigger('suffixName');
            var len = asRec.scores[i].name.length;
            maxScoreLen = len > maxScoreLen ? len : maxScoreLen;
         }
         if (maxScoreLen > 0) {
           jQuery('#asEntryPanel label').css('width', maxScoreLen + "em");
         }
       }).trigger('change');
};

cas.AsEntryManager.prototype.prepScoreEntry = function(container,scoreName, scoreType) {
   var $cont = jQuery(container);
   var map = {"integer" : "div.template.numeric", "float":"div.template.numeric",
      "varchar" : "div.template.string", "timestamp" : "div.template.date",
      "boolean" : "div.template.boolean"};
   var sel = map[scoreType];
   if (sel) {
      jQuery(sel).children().clone().appendTo(container);
      if (scoreType === 'timestamp') {
         jQuery('input[name^="dateScoreBut"]', $cont).bind('click', function(e) {
               jQuery(this).prev().filter('input[name^="score"]').datepicker(
                 {changeMonth:true, changeYear:true});
               });
      }
      jQuery('label', container).text(scoreName + ":").data('type',scoreType).data('name', scoreName);
   }
};

cas.AsEntryManager.prototype.saveAssessment = function(container, assessmentName, visitInfo) {
   var $cont = jQuery(container);
   var at = {name: assessmentName, descr:'', scores:[], values:[]};
   if (!visitInfo.assessments) {
      visitInfo.assessments = [];
   }
   visitInfo.assessments.push(at);

   var convertScoreType = function(scoreType) {
      switch(scoreType) {
        case "varchar": return "string";
        case "integer" : return "int";
        default: return scoreType;
      }
   };

   jQuery('input[name^="score"]', $cont).each( function() {
         var scoreValue = jQuery(this).val();
         var $lbl = jQuery(this).siblings('label');
         var scoreName = $lbl.data('name');  
         var scoreType = $lbl.data('type');  
         var st = {name: scoreName, type: convertScoreType(scoreType), 
                   descr:'', possibleValues:[] };
         at.scores.push(st);
         var sv = {name: scoreName, value: scoreValue};
         at.values.push(sv);
         });
   /* alert( JSON.stringify(visitInfo) ); */
   var asSelector = jQuery('.asChooser')[0];
   jQuery.filterOptionsByLabel(asSelector,[ assessmentName ]);
   jQuery.publish("newAssessment", [assessmentName]);

};

