package gtools.utils;

import java.security.*;
import java.security.cert.*;

import javax.net.ssl.*;



/*
 * Adapted from Sun's InstallCert Java code. (I Burak Ozyurt)
 *
 *
 * Copyright 2006 Sun Microsystems, Inc.  All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 *   - Neither the name of Sun Microsystems nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


class SSLCertInstall {
   String host;
   int port=443;
   char[] passphrase='changeit'.toCharArray();
   boolean verbose = false;
   
   
   public static boolean canWrite(file) {
      def outFile = new File(file);
      if (!outFile.isFile()) {
         try {
            outFile.write("testing");
            outFile.delete();
         } catch(Exception x) {
            return false;  
         }
      }  
      return true;
   }
   
   public void install() {
      char SEP = File.separatorChar;
      File dir = new File(System.getProperty("java.home") + SEP
		       + "lib" + SEP + "security");
      if (!canWrite(new File(dir,'burak').absolutePath) ) {
          println "You need admin privileges to be able to write to directory:\n$dir";
          println "Giving up..."
          return
      }
      
       File file = new File(dir, "jssecacerts");
	    if (!file.isFile()) 
         file = new File(dir, "cacerts");
       
       
       def rvMap = getTrustMan(file);
       def tm = rvMap.tm;
       
       X509Certificate[] chain = tm.chain;
	    if (chain == null) {
          println "Could not obtain server certificate chain"
          return;
       }

       if (!rvMap.trusted) {
          BufferedReader reader =
           new BufferedReader(new InputStreamReader(System.in));

          println ''
          println "Server sent  ${chain.length} certificate(s):"
          println '';
          MessageDigest sha1 = MessageDigest.getInstance("SHA1");
          MessageDigest md5 = MessageDigest.getInstance("MD5");
          for (int i = 0; i < chain.length; i++) {
             X509Certificate cert = chain[i];
             println " ${i + 1} Subject ${cert.getSubjectDN()}"
             println "   Issuer  ${cert.getIssuerDN()}";
             sha1.update(cert.getEncoded());
             println"   sha1    ${toHexString(sha1.digest())}"
             md5.update(cert.getEncoded());
             println "   md5     ${toHexString(md5.digest())}"
             println ''
          }

          println("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
          String line = reader.readLine().trim();
          int k;
          try {
             k = (line.length() == 0) ? 0 : Integer.parseInt(line) - 1;
          } catch (NumberFormatException e) {
             println "KeyStore not changed.";
             return;
          }

          X509Certificate cert = chain[k];
          String alias = host + "-" + (k + 1);
          KeyStore ks = rvMap.ks;
          ks.setCertificateEntry(alias, cert);

          OutputStream out = new FileOutputStream(new File(dir, "jssecacerts"));
          ks.store(out, passphrase);
          out.close();

          println '';
          println "$cert";
          println '';
          println "Added certificate to keystore '${new File(dir, "jssecacerts")}' using alias '$alias'"
       }

   }
   
   def getTrustMan(File file) {
       println "Loading KeyStore $file ..."
       
       InputStream is = new FileInputStream(file);
       KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
       ks.load(is, passphrase);
       is.close();
   
       SSLContext context = SSLContext.getInstance("TLS");
       TrustManagerFactory tmf =
	       TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
       tmf.init(ks);
       X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];   
       SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
       context.init(null, [tm].toArray() as TrustManager[] , null);
       SSLSocketFactory factory = context.getSocketFactory();

       println "Opening connection to $host:${port}..."
       SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
       socket.setSoTimeout(10000);
       try {
          println 'Starting SSL handshake...';
          socket.startHandshake();
          socket.close();
          println ''
          println 'No errors, certificate is already trusted.'
          return [tm:tm, trusted:true, ks:ks];
       } catch (SSLException e) {
          println ''
          println "${e.getMessage()}"
          if (verbose) e.printStackTrace();
       }  
       return [tm:tm, trusted:false, ks:ks];
   }
   
   def static getAnswer() {
      return new BufferedReader(new InputStreamReader(System.in)).readLine().trim(); 
   }
   
   public static void installCert(host='localhost', port=443) {
      print "Please enter Web Service Server hostname (e.g. loci.ucsd.edu):"
      String ans = getAnswer(); 
      def s = null;
      if (ans.length() > 0)   
        host = ans
      print "Please enter Web Service Server port [443]:"
      ans = getAnswer();
      if (ans.length() > 0)
        port = getInt(ans, 443)
      s = new SSLCertInstall(host : host, port : port);
      s.install()
   }
   
   def static getInt(String s, int defValue) {
     try {
       return Integer.parseInt(s);
     } catch(Throwable t) {
        return defValue
     }
   }
   private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    private static String toHexString(byte[] bytes) {
	    StringBuilder sb = new StringBuilder(bytes.length * 3);
	   for (int b : bytes) {
	     b &= 0xff;
	     sb.append(HEXDIGITS[b >> 4]);
	     sb.append(HEXDIGITS[b & 15]);
	     sb.append(' ');
	   }
	   return sb.toString();
    }
   
   
}

class SavingTrustManager implements X509TrustManager {
	  private final X509TrustManager tm;
	  private X509Certificate[] chain;

	  SavingTrustManager(X509TrustManager tm) {
	    this.tm = tm;
	  }

	 public X509Certificate[] getAcceptedIssuers() {
	    throw new UnsupportedOperationException();
	 }

	 public void checkClientTrusted(X509Certificate[] chain, String authType)
	 	throws CertificateException {
	     throw new UnsupportedOperationException();
	 }

	 public void checkServerTrusted(X509Certificate[] chain, String authType)
		throws CertificateException {
	    this.chain = chain;
	    tm.checkServerTrusted(chain, authType);
	 }
   }//;



