package clinical.comm;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.jdom.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Collection.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class Collection implements IXMLSerializer {
	protected List<IXMLSerializer> elements = new LinkedList<IXMLSerializer>();

	public Collection() {
	}

	public void add(IXMLSerializer element) {
		elements.add(element);
	}

	public int getSize() {
		return this.elements.size();
	}

	public Iterator<? extends IXMLSerializer> iterator() {
		return elements.iterator();
	}

	public Element toXML() {
		Element e = new Element("collection");
		for (Iterator<IXMLSerializer> iter = elements.iterator(); iter
				.hasNext();) {
			IXMLSerializer elem = iter.next();
			Element ee = new Element("elem");
			Element ce = elem.toXML();
			ee.addContent(ce);
			e.addContent(ee);
		}
		return e;
	}

	public void initializeFromXML(Element e) {
		List<?> children = e.getChildren("elem");
		for (Iterator<?> iter = children.iterator(); iter.hasNext();) {
			Element ee = (Element) iter.next();
			List<?> cl = ee.getChildren();
			if (cl != null && !cl.isEmpty()) {
				Element ve = (Element) cl.get(0);
				IXMLSerializer value = Utils.initFromXML(ve);
				add(value);
			}
		}
	}
}
