package clinical.comm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.jdom.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Request.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class Request {
	protected String action;
	protected List<Parameter> params = new ArrayList<Parameter>(3);

	public Request() {
	}

	public Request(String action) {
		this.action = action;
	}

	public void addParam(Parameter param) {
		params.add(param);
	}

	public List<Parameter> getParams() {
		return params;
	}

	public Parameter getParam(int idx) {
		return params.get(idx);
	}

	public int getNumOfParams() {
		if (params == null)
			return 0;
		return params.size();
	}

	public String getAction() {
		return action;
	}

	public Element toXML() {
		Element e = new Element("request");
		Element ae = new Element("action");
		ae.addContent(action);
		e.addContent(ae);
		for (Iterator<Parameter> iter = params.iterator(); iter.hasNext();) {
			Parameter p = iter.next();
			Element pe = p.toXML();
			e.addContent(pe);
		}
		return e;
	}

	public void initializeFromXML(Element e) {
		Element ae = e.getChild("action");
		this.action = ae.getTextTrim();
		List<?> c = e.getChildren("param");
		for (Iterator<?> iter = c.iterator(); iter.hasNext();) {
			Element pe = (Element) iter.next();
			Parameter p = new Parameter();
			p.initializeFromXML(pe);
			addParam(p);
		}
	}
}
