package clinical.comm;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SimpleRequestHandler.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class SimpleRequestHandler {
	protected Map<String, IRequestProcessor> registeredHandlersMap = new HashMap<String, IRequestProcessor>();

	public SimpleRequestHandler() {
	}

	public void registerHandler(String action,
			IRequestProcessor requestProcessor) {
		registeredHandlersMap.put(action, requestProcessor);
	}

	public Response handleRequest(Request req) throws XMLMessagingException {
		IRequestProcessor rp = registeredHandlersMap
				.get(req.getAction());
		if (rp == null)
			throw new XMLMessagingException(
					"No registered request handler for action "
							+ req.getAction());

		return rp.execute(req.getAction(), req);
	}

}
