package clinical.server;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.dao.oracle.ExpcomponentDAO;
import clinical.server.dao.oracle.ExpsegmentDAO;
import clinical.server.dao.oracle.HumansubjectDAO;
import clinical.server.dao.oracle.SubjexperimentDAO;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Subjexperiment;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ExperimentManager.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ExperimentManager {

	public ExperimentManager() {
	}

	public void addResearchGroup(Connection con, String resGroupName,
			String resGroupDesc, String resGroupType, String expName,
			String owner, String modUser) throws Exception {
		CallableStatement cst = null;
		/**
		 * @todo 2nd tier validation or rely on servlet container side
		 *       validation ?
		 */
		try {
			cst = con.prepareCall("{call add_research_group(?,?,?,?,?,?)}");
			cst.setString(1, resGroupName);
			cst.setString(2, resGroupDesc);
			cst.setString(3, resGroupType);
			cst.setString(4, expName);
			cst.setString(5, owner);
			cst.setString(6, modUser);
			cst.execute();

		} finally {
			if (cst != null)
				try {
					cst.close();
				} catch (Exception x) { /* ignore */
				}

		}
	}

	/**
	 * for old BIRN db schema (08/14/03)
	 */
	public void addExperimentInfo(Connection con, String birnID,
			String expName, String researchGroupName, BigDecimal visitID,
			java.util.Date visitDate, String visitDescp, String visitType,
			String owner, String modUser) throws SQLException {
		CallableStatement cst = null;
		/**
		 * @todo 2nd tier validation or rely on servlet container side
		 *       validation ?
		 */
		try {
			cst = con.prepareCall("{call add_exp_info(?,?,?,?,?,?,?,?,?)}");
			cst.setString(1, birnID);
			cst.setString(2, expName);
			cst.setString(3, researchGroupName);
			cst.setBigDecimal(4, visitID);
			cst.setTimestamp(5, new Timestamp(visitDate.getTime()));
			cst.setString(6, visitDescp);
			cst.setString(7, visitType);
			cst.setString(8, owner);
			cst.setString(9, modUser);
			cst.execute();

		} finally {
			if (cst != null)
				try {
					cst.close();
				} catch (Exception x) { /* ignore */
				}

		}
	}

	/**
	 * for new BIRN db schema (08/14/03)
	 * 
	 */
	/*
	 * birn_id_in VARCHAR2, exp_name_in VARCHAR2, research_group_name_in
	 * VARCHAR2, visit_id_in NUMBER, visit_date_in TIMESTAMP, visit_descr_in
	 * VARCHAR2, visit_type_in VARCHAR2, -- IBO (7/15) segment_id_in NUMBER,
	 * segment_descr_in VARCHAR2, protocol_version_in NUMBER, protocol_id_in
	 * VARCHAR2, owner_name_in VARCHAR2, mod_user_in VARCHAR2
	 */
	public void addExperimentInfo2(Connection con, String birnID,
			String expName, String researchGroupName, BigDecimal visitID,
			java.util.Date visitDate, String visitDescp, String visitType,
			BigDecimal segmentID, String segmentDesc,
			BigDecimal protocolVersion, String protocolID, String owner,
			String modUser, BigDecimal secLabel) throws SQLException {
		CallableStatement cst = null;
		/**
		 * @todo 2nd tier validation or rely on servlet container side
		 *       validation ?
		 */
		try {
			cst = con
					.prepareCall("{call add_exp_info(?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
			cst.setString(1, birnID);
			cst.setString(2, expName);
			cst.setString(3, researchGroupName);
			cst.setBigDecimal(4, visitID);
			cst.setTimestamp(5, new Timestamp(visitDate.getTime()));
			cst.setString(6, visitDescp);
			cst.setString(7, visitType);
			cst.setBigDecimal(8, segmentID);
			cst.setString(9, segmentDesc);
			cst.setBigDecimal(10, protocolVersion);
			cst.setString(11, protocolID);
			cst.setString(12, owner);
			cst.setString(13, modUser);
			cst.setBigDecimal(14, secLabel);
			cst.execute();

		} finally {
			if (cst != null)
				try {
					cst.close();
				} catch (Exception x) { /* ignore */
				}

		}
	}

	public void removeExperimentInfo(Connection con, String birnID,
			String expName, String researchGroupName, String owner,
			String modUser) throws SQLException {
		CallableStatement cst = null;
		/**
		 * @todo 2nd tier validation or rely on servlet container side
		 *       validation ?
		 */
		try {
			cst = con.prepareCall("{call drop_exp_info(?,?,?,?,?)}");
			cst.setString(1, birnID);
			cst.setString(2, expName);
			cst.setString(3, researchGroupName);
			cst.setString(4, owner);
			cst.setString(5, modUser);
			cst.execute();
		} finally {
			if (cst != null)
				try {
					cst.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	public void removeVisitsForSubject(Connection con, String birnID,
			String experimentName, String researchGroupName, int lowVisitID,
			int highVisitID, String ownerName, String modUser)
			throws SQLException {
		CallableStatement cst = null;
		try {
			cst = con
					.prepareCall("{call remove_visits_for_subject(?,?,?,?,?,?,?}");
			cst.setString(1, birnID);
			cst.setString(2, experimentName);
			cst.setString(3, researchGroupName);
			cst.setBigDecimal(4, new BigDecimal(lowVisitID));
			cst.setBigDecimal(5, new BigDecimal(highVisitID));
			cst.setString(6, ownerName);
			cst.setString(7, modUser);

		} finally {
			if (cst != null)
				try {
					cst.close();
				} catch (Exception x) { /* ignore */
				}
		}

	}

	protected List<Expsegment> getSegments(Connection con, Expcomponent visit)
			throws Exception {
		ExpsegmentDAO dao = new ExpsegmentDAO();
		Expsegment criteria = new Expsegment();
		criteria.setComponentid(visit.getComponentid());
		criteria.setSubjectid(visit.getSubjectid());
		criteria.setNcExperimentUniqueid(visit.getNcExperimentUniqueid());

		List<Expsegment> segments = dao.find(con, criteria);
		return segments;
	}

	public List<ExperimentInfo> getExperimentInfos(Connection con, Subjexperiment criteria)
			throws Exception {
		List<ExperimentInfo> expInfos = new LinkedList<ExperimentInfo>();
		SubjexperimentDAO subExpDAO = new SubjexperimentDAO();
		List<Subjexperiment> subExpList = subExpDAO.find(con, criteria);
		System.out.println("got subjexperiments");
		if (subExpList.isEmpty())
			return expInfos;
		for (Subjexperiment subExp : subExpList) {
			ExperimentInfo ei = new ExperimentInfo();
			ei.setSubjectExp(subExp);
			expInfos.add(ei);

			ExpcomponentDAO ecDAO = new ExpcomponentDAO();
			Expcomponent ecCriteria = new Expcomponent();
			ecCriteria
					.setNcExperimentUniqueid(subExp.getNcExperimentUniqueid());
			ecCriteria.setSubjectid(subExp.getSubjectid());

			List<Expcomponent> ecList = ecDAO.find(con, ecCriteria);
			System.out.println("got ecList");
			for (Expcomponent visit : ecList) {
				ei.addVisit(visit);
				// get segments also
				List<Expsegment> segments = getSegments(con, visit);
				for (Expsegment segment : segments) {
					ei.addSegment(visit, segment);
				}
			}

			// get human subject
			Humansubject hsCriteria = new Humansubject();
			HumansubjectDAO hsDAO = new HumansubjectDAO();
			hsCriteria.setSubjectid(subExp.getSubjectid());
			List<Humansubject> hsList = hsDAO.find(con, hsCriteria);
			System.out.println("got hsList");
			if (!hsList.isEmpty()) {
				ei.setHumanSubject((Humansubject) hsList.get(0));

			}
		}
		return expInfos;
	}

	public void test(Connection con) throws Exception {
		Subjexperiment criteria = new Subjexperiment();
		List<ExperimentInfo> eiList = getExperimentInfos(con, criteria);
		for (Iterator<ExperimentInfo> it = eiList.iterator(); it.hasNext();) {
			ExperimentInfo ei = it.next();
			System.out.println(ei);
		}

	}

	public static void usage() {
		System.err
				.println("java clinical.server.ExperimentManager <dbURL> <usr> <pwd>");
		System.err
				.println("\twhere dbURL has the following syntax jdbc:oracle:thin:@<host>:<port>:<sid>");
		System.exit(1);
	}

	// test driver
	public static void main(String[] args) {
		Connection con = null;
		if (args.length != 3)
			usage();

		String dbURL = args[0];
		String user = args[1];
		String pwd = args[2];

		ExperimentManager em = new ExperimentManager();
		try {
			Class.forName("oracle.jdbc.driver.OracleDriver");
			con = DriverManager.getConnection(dbURL, user, pwd);

			em.test(con);

		} catch (Exception x) {
			x.printStackTrace();
		} finally {
			if (con != null)
				try {
					con.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}
}