package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Executedtransform;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ExecutedtransformDAO implements
		clinical.server.dao.ExecutedtransformDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ExecutedtransformDAO() {
	}

	public void insert(Connection con, Executedtransform bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_EXECUTEDTRANSFORM ");
			buf
					.append(" (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,LOGICALTRANSFORMID,NC_DATABASEUSER_UNIQUEID,MACHINEID,TIME_STAMP,COMPILERID,ANALYSISCOMPONENTID,PARENTEXECUTEDTRANSFORMATIONID,NODELEVEL,ANALYSISID,ARGUMENTSUSED) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 15; ++i) {
				buf.append('?');
				if (i < 14)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(4, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(5, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(6,
					(java.math.BigDecimal) bean.getLogicaltransformid(),
					Types.NUMERIC);
			ps.setObject(7, (java.math.BigDecimal) bean
					.getNcDatabaseuserUniqueid(), Types.NUMERIC);
			ps.setObject(8, (java.math.BigDecimal) bean.getMachineid(),
					Types.NUMERIC);
			ps.setObject(9, (java.sql.Timestamp) bean.getTimeStamp(),
					Types.TIMESTAMP);
			ps.setObject(10, (java.math.BigDecimal) bean.getCompilerid(),
					Types.NUMERIC);
			ps.setObject(11, (java.math.BigDecimal) bean
					.getAnalysiscomponentid(), Types.NUMERIC);
			ps.setObject(12, (java.math.BigDecimal) bean
					.getParentexecutedtransformationid(), Types.NUMERIC);
			ps.setObject(13, (java.math.BigDecimal) bean.getNodelevel(),
					Types.NUMERIC);
			ps.setObject(14, (java.math.BigDecimal) bean.getAnalysisid(),
					Types.NUMERIC);
			ps.setObject(15, (String) bean.getArgumentsused(), Types.VARCHAR);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Executedtransform bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("LOGICALTRANSFORMID");
		buf.append(',');
		buf.append("NC_DATABASEUSER_UNIQUEID");
		buf.append(',');
		buf.append("MACHINEID");
		buf.append(',');
		buf.append("TIME_STAMP");
		buf.append(',');
		buf.append("COMPILERID");
		buf.append(',');
		buf.append("ANALYSISCOMPONENTID");
		buf.append(',');
		buf.append("PARENTEXECUTEDTRANSFORMATIONID");
		buf.append(',');
		buf.append("NODELEVEL");
		buf.append(',');
		buf.append("ANALYSISID");
		buf.append(',');
		buf.append("ARGUMENTSUSED");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Executedtransform bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getLogicaltransformid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("LOGICALTRANSFORMID=?");
			qi.values.add(bean.getLogicaltransformid());
			valueSet = true;
		}
		if (bean.getNcDatabaseuserUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NC_DATABASEUSER_UNIQUEID=?");
			qi.values.add(bean.getNcDatabaseuserUniqueid());
			valueSet = true;
		}
		if (bean.getMachineid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MACHINEID=?");
			qi.values.add(bean.getMachineid());
			valueSet = true;
		}
		if (bean.getTimeStamp() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TIME_STAMP=?");
			qi.values.add(bean.getTimeStamp());
			valueSet = true;
		}
		if (bean.getCompilerid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMPILERID=?");
			qi.values.add(bean.getCompilerid());
			valueSet = true;
		}
		if (bean.getAnalysiscomponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ANALYSISCOMPONENTID=?");
			qi.values.add(bean.getAnalysiscomponentid());
			valueSet = true;
		}
		if (bean.getParentexecutedtransformationid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PARENTEXECUTEDTRANSFORMATIONID=?");
			qi.values.add(bean.getParentexecutedtransformationid());
			valueSet = true;
		}
		if (bean.getNodelevel() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NODELEVEL=?");
			qi.values.add(bean.getNodelevel());
			valueSet = true;
		}
		if (bean.getAnalysisid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ANALYSISID=?");
			qi.values.add(bean.getAnalysisid());
			valueSet = true;
		}
		if (bean.getArgumentsused() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ARGUMENTSUSED=?");
			qi.values.add(bean.getArgumentsused());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Executedtransform bean,
			Executedtransform criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_EXECUTEDTRANSFORM SET ");

		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getLogicaltransformid() != null
				|| bean.isNull("logicaltransformid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("LOGICALTRANSFORMID=? ");
			uqi.setValues.add(bean.getLogicaltransformid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("logicaltransformid"), uqi);
			valueSet = true;
		}
		if (bean.getNcDatabaseuserUniqueid() != null
				|| bean.isNull("ncDatabaseuserUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NC_DATABASEUSER_UNIQUEID=? ");
			uqi.setValues.add(bean.getNcDatabaseuserUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncDatabaseuserUniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getMachineid() != null || bean.isNull("machineid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MACHINEID=? ");
			uqi.setValues.add(bean.getMachineid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("machineid"), uqi);
			valueSet = true;
		}
		if (bean.getTimeStamp() != null || bean.isNull("timeStamp")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TIME_STAMP=? ");
			uqi.setValues.add(bean.getTimeStamp());
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("timeStamp"), uqi);
			valueSet = true;
		}
		if (bean.getCompilerid() != null || bean.isNull("compilerid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMPILERID=? ");
			uqi.setValues.add(bean.getCompilerid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("compilerid"), uqi);
			valueSet = true;
		}
		if (bean.getAnalysiscomponentid() != null
				|| bean.isNull("analysiscomponentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ANALYSISCOMPONENTID=? ");
			uqi.setValues.add(bean.getAnalysiscomponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("analysiscomponentid"), uqi);
			valueSet = true;
		}
		if (bean.getParentexecutedtransformationid() != null
				|| bean.isNull("parentexecutedtransformationid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PARENTEXECUTEDTRANSFORMATIONID=? ");
			uqi.setValues.add(bean.getParentexecutedtransformationid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean
					.isNull("parentexecutedtransformationid"), uqi);
			valueSet = true;
		}
		if (bean.getNodelevel() != null || bean.isNull("nodelevel")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NODELEVEL=? ");
			uqi.setValues.add(bean.getNodelevel());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("nodelevel"), uqi);
			valueSet = true;
		}
		if (bean.getAnalysisid() != null || bean.isNull("analysisid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ANALYSISID=? ");
			uqi.setValues.add(bean.getAnalysisid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("analysisid"), uqi);
			valueSet = true;
		}
		if (bean.getArgumentsused() != null || bean.isNull("argumentsused")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ARGUMENTSUSED=? ");
			uqi.setValues.add(bean.getArgumentsused());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("argumentsused"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Executedtransform createObject(ResultSet rs) throws SQLException {
		Executedtransform obj = new Executedtransform();
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		if (rs.getTimestamp(4) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(4).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		obj.setLogicaltransformid((java.math.BigDecimal) rs.getObject(6));
		obj.setNcDatabaseuserUniqueid((java.math.BigDecimal) rs.getObject(7));
		obj.setMachineid((java.math.BigDecimal) rs.getObject(8));
		obj.setTimeStamp(OracleUtils.getTimestamp(rs.getObject(9)));
		obj.setCompilerid((java.math.BigDecimal) rs.getObject(10));
		obj.setAnalysiscomponentid((java.math.BigDecimal) rs.getObject(11));
		obj.setParentexecutedtransformationid((java.math.BigDecimal) rs
				.getObject(12));
		obj.setNodelevel((java.math.BigDecimal) rs.getObject(13));
		obj.setAnalysisid((java.math.BigDecimal) rs.getObject(14));
		obj.setArgumentsused((String) rs.getObject(15));
		return obj;
	}

	public List<Executedtransform> find(Connection con,
			Executedtransform criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Executedtransform> results = new LinkedList<Executedtransform>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_EXECUTEDTRANSFORM ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Executedtransform item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Executedtransform bean,
			Executedtransform criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Executedtransform criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_EXECUTEDTRANSFORM ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
