package clinical.server.utils;

import java.io.*;
import java.sql.*;

import oracle.sql.*;

/**
 *  Allows reading and writing of an Oracle CLOB to and from a Java String.
 *
 *  @author I. Burak Ozyurt
 *  @version $Id: OracleUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class OracleUtils {

  protected OracleUtils() {}

  /**
   *
   * @param clob the Oracle CLOB to red in
   * @return the String containing the CLOB data
   * @throws SQLException
   */
  public static String readCLOB(oracle.sql.CLOB clob) throws SQLException {
    if (clob == null)
       return null;
    StringBuffer buf = new StringBuffer(128);
    Reader r = clob.characterStreamValue();
    int c;
    try {
      while( (c = r.read()) != -1) {
        buf.append((char)c);
      }
    } catch(IOException iox) {
      throw new SQLException(iox.getMessage() );
    }
    return buf.toString();
  }

  /**
   *
   * @param con JDBC connection
   * @param data string containing data to be put into an Oracle CLOB
   * @return the CLOB object created and initialized from the String passed
   * @throws SQLException
   */
  public static CLOB getCLOB(Connection con, String data) throws SQLException {
    CLOB tempClob = null;
    Writer w = null;
    try {
      tempClob = CLOB.createTemporary(con, true, CLOB.DURATION_SESSION);
      tempClob.open(CLOB.MODE_READWRITE);
      w = tempClob.getCharacterOutputStream();
      w.write(data);
      w.flush();
    } catch(Exception x) {
      if (tempClob != null)
        tempClob.freeTemporary();
        x.printStackTrace();
      throw new SQLException(x.getMessage() );
    } finally {
      if (w != null) {
        try {
          w.close();
          } catch(Exception x) { /* ignore */ }
      }
    }
    return tempClob;
  }
  
  public static String escapeQuotes(String str) {
     if ( str == null) {
         return str;
     }
     if ( str.indexOf('\'') != -1) {
         str = str.replaceAll("'","''");
     }
     return str;
  }
  
  public static java.sql.Timestamp getTimestamp(Object value) throws SQLException {
	  if ( value == null) {
		  return null;
	  }	  
	  
	  //return ((TIMESTAMP) value).timestampValue();
	  return ((oracle.sql.DATE) value).timestampValue();
  }

}
