package clinical.storage;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.globus.myproxy.MyProxy;
import org.ietf.jgss.GSSCredential;

import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.download.PathWrapper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StorageUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class StorageUtils {

	private StorageUtils() {}

	public static void recurseDir(List<PathWrapper> pwList, File localDir,
			String cacheDir, String sourceRootDir) {
		File[] localFiles = localDir.listFiles();
		for (File lf : localFiles) {
			if (lf.isFile()) {
				String filePath = lf.getAbsolutePath();
				if (filePath.startsWith(cacheDir)) {
					filePath = filePath.substring(cacheDir.length());
					filePath = filePath.replaceFirst("^\\/+", "");
				}
				pwList.add(new PathWrapper(filePath, sourceRootDir));
			} else {
				recurseDir(pwList, lf, cacheDir, sourceRootDir);
			}
		}
	}

	public static void prepareGridFtpPluginParams(IAppConfigService acs,
			Map<String, Object> paramMap, String webUser, String pwd)
			throws Exception {
		prepareGridFtpParams(acs, paramMap);

		String myproxyHost = acs.getParamValue(Constants.MYPROXY_HOST_KEY);
		int myproxyPort = GenUtils.toInt(acs
				.getParamValue(Constants.MYPROXY_PORT_KEY), 7512);
		System.out.println("myproxyHost:" + myproxyHost + " myproxyPort:"
				+ myproxyPort);
		MyProxy proxy = new MyProxy(myproxyHost, myproxyPort);
		GSSCredential credential = proxy.get(webUser, pwd, 0);
		paramMap.put("credential", credential);
	}

	public static void prepareGridFtpPluginParams(IAppConfigService acs,
			Map<String, Object> paramMap, GSSCredential credential)
			throws Exception {
		prepareGridFtpParams(acs, paramMap);
		paramMap.put("credential", credential);
	}

	protected static void prepareGridFtpParams(IAppConfigService acs,
			Map<String, Object> paramMap) {
		paramMap.put("myproxy.host", acs
				.getParamValue(Constants.MYPROXY_HOST_KEY));
		paramMap.put("rls.url", acs.getParamValue(Constants.RLS_URL_KEY));
		paramMap.put("gridftp.port", acs
				.getParamValue(Constants.GRIDFTP_PORT_KEY));
		paramMap.put("myproxy.port", acs
				.getParamValue(Constants.MYPROXY_PORT_KEY));
		paramMap.put("master.site.gridftp.host", acs
				.getParamValue(Constants.MASTER_GRIDFTP_HOST_KEY));
	}
}
