package clinical.test;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;

import junit.framework.TestSuite;
import clinical.server.dao.AssessmentDAO;
import clinical.server.dao.AssessmentintegerDAO;
import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentinteger;
import clinical.web.DAOFactory;
import clinical.web.common.UserInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentQueryTest.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class AssessmentQueryTest extends MyTestCase {
	String owner;
	String modUser;

	public AssessmentQueryTest(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile, true);
	}

	protected void setUp() throws Exception {
		super.setUp();
		owner = getProperty("fbirn.owner");
		modUser = getProperty("fbirn.moduser");
	}

	public List<Assessment> testGetAllAssessments(UserInfo userInfo)
			throws Exception {
		Connection con = null;
		try {
			AssessmentDAO asDAO = DAOFactory.createAssessmentDAO(getDbID());
			con = getConnection();
			System.out.println(">>&&& asDAO.find()");
			List<Assessment> assessments = asDAO.find(con, new Assessment());
			return assessments;
		} finally {
			releaseConnection(con);
		}
	}

	public void testGetAssessmentInteger() throws Exception {
		Connection con = null;
		try {
			AssessmentintegerDAO aiDAO = DAOFactory
					.createAssessmentintegerDAO(getDbID());
			con = getConnection();
			Assessmentinteger cr = new Assessmentinteger();
			cr.setAssessmentid(new BigDecimal("252"));
			// cr.setSubjectid("009027365430");
			List<Assessmentinteger> list = aiDAO.find(con, cr);
			for (Object element : list) {
				Object item = (Object) element;
				System.out.println(item.toString());
			}
		} finally {
			releaseConnection(con);
		}
	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		// suite.addTest( new AssessmentQueryTest("testGetAllAssessments",
		// "test.properties") );
		suite.addTest(new AssessmentQueryTest("testGetAssessmentInteger",
				"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}
