package clinical.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;

import junit.framework.TestSuite;
import clinical.web.common.UserInfo;
import clinical.web.services.DBPoolService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DBPoolLoadTest.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class DBPoolLoadTest extends MyTestCase {
	String dbID;

	public DBPoolLoadTest(String testName, String propsFile) throws IOException {
		super(testName, propsFile, true);
		dbID = getProperty("mbirn.dbid");
	}

	public void testLoad() throws Exception {
		int numClients = 20;
		Thread[] threads = new Thread[numClients];
		MockClient[] clients = new MockClient[numClients];
		for (int i = 0; i < threads.length; i++) {
			threads[i] = new Thread(clients[i] = new MockClient(String
					.valueOf(i + 1), getUi(), this.dbID));
			threads[i].setDaemon(true);
			threads[i].setPriority(Thread.NORM_PRIORITY - 1);
			threads[i].start();
		}
		for (int i = 0; i < threads.length; i++) {
			try {
				threads[i].join();
			} catch (InterruptedException iex) {
			}
		}

		for (int i = 0; i < clients.length; i++) {
			if (!clients[i].wasSuccess())
				fail();
		}
	}

	class MockClient implements Runnable {
		String id;
		String dbID;
		UserInfo userInfo;
		boolean success = true;

		public MockClient(String id, UserInfo userInfo, String dbID) {
			this.id = id;
			this.dbID = dbID;
			this.userInfo = userInfo;
		}

		public boolean wasSuccess() {
			return success;
		}

		public void run() {
			Connection con = null;
			Statement st = null;
			Random rnd = new Random();
			for (int i = 0; i < 10; ++i) {
				try {
					System.out.println("Client: " + id + " query : " + (i + 1));
					con = DBPoolService.getInstance(dbID).getConnection(
							userInfo.getName());
					st = con.createStatement();
					ResultSet rs = st.executeQuery("select sysdate from dual");
					rs.close();
					try {
						Thread.sleep(rnd.nextInt(1000));
					} catch (InterruptedException ie) {
					}
				} catch (Exception x) {
					x.printStackTrace();
					success = false;
					break;
				} finally {
					if (st != null)
						try {
							st.close();
						} catch (Exception x) {
						}
					if (con != null) {
						try {
							DBPoolService.getInstance(dbID).releaseConnection(
									userInfo.getName(), con);
						} catch (Exception x) {
							x.printStackTrace();
							success = false;
							break;
						}
					}
				}
			}
		}
	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite.addTest(new DBPoolLoadTest("testLoad", "test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}