package clinical.test;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import junit.framework.TestSuite;
import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentscorecode;
import clinical.web.IAssessmentService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.query.QueryPartInfo;
import clinical.web.helpers.AssessmentSelectionInfoHelper;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.helpers.StoredQueryDescription;

/**
 * @author I. Burak Ozyurt
 * @version $Id: PersistentQueryTest.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class PersistentQueryTest extends MyTestCase {
	protected String dbID;

	public PersistentQueryTest(String name, String propsFile) throws IOException {
		// skip queryCache
		super(name, propsFile, true);
		dbID = getProperty("mbirn.dbid");
	}

	public void testQueryDeserialization() throws Exception {
		IAssessmentService asService = ServiceFactory
				.getAssessmentService(this.dbID);
		IDBCache dbCache = ServiceFactory.getDBCache(this.dbID);
		Map<String, List<Assessmentscorecode>> scoreCodeMap = dbCache
				.getScoreCodeMap(super.getUi(), false);
		List<Assessment> assessments = asService.getAllAssessments(super.getUi());
		AssessmentSelectionInfoHelper helper = new AssessmentSelectionInfoHelper(
				asService, getUi(), assessments, scoreCodeMap);

		List<QueryPartInfo> queryParts = QueryWizardHelper.loadQueryFromFile(
				"/home/bozyurt/dev/java/clinical/conf/test/query.xml", helper);
		assertTrue(queryParts != null && queryParts.size() > 0);

		for (QueryPartInfo qpi : queryParts) {
			if (qpi.getScoreInfo() != null) {
				assertTrue("Score Info " + qpi.getScoreInfo().getName()
						+ " must be selected", qpi.getScoreInfo().isSelected());
			} else {
				assertTrue("Subcortical score "
						+ qpi.getSubCorticalVarInfo().getBrainRegionName()
						+ " must be selected", qpi.getSubCorticalVarInfo()
						.isSelected());
			}
		}
	}

	public void testQueryDeserializationFromDB() throws Exception {
		IAssessmentService asService = ServiceFactory
				.getAssessmentService(this.dbID);
		List<Assessment> assessments = asService.getAllAssessments(super.getUi());

		IDBCache dbCache = ServiceFactory.getDBCache(this.dbID);
		Map<String, List<Assessmentscorecode>> scoreCodeMap = dbCache
				.getScoreCodeMap(super.getUi(), false);

		AssessmentSelectionInfoHelper helper = new AssessmentSelectionInfoHelper(
				asService, getUi(), assessments, scoreCodeMap);

		// List queryParts =
		StoredQueryDescription sqd = QueryWizardHelper.loadQueryFromDB(this.getUi(),
				asService, 12650, "b", helper);

		assertTrue(sqd.getQueryParts() != null
				&& sqd.getQueryParts().size() > 0);

		for (QueryPartInfo qpi : sqd.getQueryParts()) {
			if (qpi.getScoreInfo() != null) {
				assertTrue("Score Info " + qpi.getScoreInfo().getName()
						+ " must be selected", qpi.getScoreInfo().isSelected());
			} else {
				assertTrue("Subcortical score "
						+ qpi.getSubCorticalVarInfo().getBrainRegionName()
						+ " must be selected", qpi.getSubCorticalVarInfo()
						.isSelected());
			}
		}
	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		// suite.addTest( new PersistentQueryTest("testQueryDeserialization",
		// "test.properties") );
		suite.addTest(new PersistentQueryTest("testQueryDeserializationFromDB",
				"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}
