package clinical.test;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import clinical.server.dao.postgres.AssessmentDAO;
import clinical.server.vo.Assessment;
import clinical.utils.GenUtils;
import clinical.web.DBUtils;
import clinical.web.vo.AssessmentInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PostgresDBTest.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class PostgresDBTest extends TestCase {
	protected Connection con;

	public PostgresDBTest(String testName) {
		super(testName);
	}

	protected void setUp() throws Exception {
		Class.forName("org.postgresql.Driver");
		Properties props = null;
		try {
			props = GenUtils.loadProperties("test.properties");
		} catch (IOException x) {
			x.printStackTrace();
		}

		String dbURL = props.getProperty("mbirn.dburl",
				"jdbc:postgresql://localhost/clinical");
		String user = props.getProperty("mbirn.user", "postgres");
		String pwd = props.getProperty("mbirn.pwd");

		con = DriverManager.getConnection(dbURL, user, pwd);
	}

	protected void tearDown() throws Exception {
		if (con != null) {
			try {
				con.close();
			} catch (Exception x) {
			}
		}
	}

	public void testQueryAssessment() throws Exception {
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st
					.executeQuery("select description from nc_assessment");
			while (rs.next()) {
				System.out.println(rs.getObject(1));
			}
			rs.close();
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
	}

	public void testQueryAssessmentViaDAO() throws Exception {
		AssessmentDAO dao = new AssessmentDAO();

		List<Assessment> recs = dao.find(con, new Assessment());
		for (Assessment item : recs) {
			System.out.println(item.toString());
		}

	}

	public void testInsertAssessment() throws Exception {
		AssessmentDAO dao = new AssessmentDAO();
		Assessment a = new Assessment();
		a.setAssessmentid(new BigDecimal("1234567"));
		a.setName("BDPT");
		a.setDescription("Burak's Dummy Pysch Test");
		a.setOwner(new BigDecimal("1"));
		a.setModuser(new BigDecimal("1"));
		a.setModtime(new Timestamp(System.currentTimeMillis()));
		a.setTableid(new BigDecimal("2"));

		dao.insert(con, a);
	}

	public void testDeleteAssessment() throws Exception {
		AssessmentDAO dao = new AssessmentDAO();
		Assessment a = new Assessment();
		a.setAssessmentid(new BigDecimal("1234567"));
		dao.delete(con, a);

	}

	public void testGetAssessmentIDSubject() throws Exception {
		String subjectID = "000899127551";
		subjectID = "000898268869";
		int experimentID = 7;
		CallableStatement cst = null;
		try {
			cst = con.prepareCall("{ ? = call assessment_man__get_asid(?,?)}");
			cst.registerOutParameter(1, Types.INTEGER);
			cst.setString(2, subjectID);
			cst.setInt(3, experimentID);
			cst.execute();
			Integer asID = (Integer) cst.getObject(1);
			System.out.println("asID=" + asID);

		} finally {
			if (cst != null)
				try {
					cst.close();
				} catch (Exception x) {
				}
		}

	}

	public void testGetAssessmentsForSubject() throws Exception {
		String subjectID = "000899127551";
		subjectID = "000898268869";
		int experimentID = 7;
		CallableStatement cst = null;
		List<AssessmentInfo> asList = new LinkedList<AssessmentInfo>();
		try {
			cst = con
					.prepareCall("{ ? = call assessment_man__get_assessments(?,?)}");
			cst.registerOutParameter(1, Types.OTHER);
			cst.setString(2, subjectID);
			cst.setInt(3, experimentID);
			cst.execute();
			ResultSet rs = (ResultSet) cst.getObject(1);
			// PGRefCursorResultSet rs = (PGRefCursorResultSet)
			// cst.getObject(1);
			while (rs.next()) {

				// System.out.println(rs.getObject(1)+ ", " + rs.getObject(2) +
				// ", " + rs.getString(3) + " visit="+
				// rs.getInt(4) + " segment "+ rs.getInt(5));

				int assessmentID = rs.getInt(1);
				java.util.Date modTime = rs.getDate(2);
				String name = rs.getString(3);
				int visitID = rs.getInt(4);
				int segmentID = rs.getInt(5);
				AssessmentInfo asi = new AssessmentInfo(assessmentID, name,
						modTime, visitID, segmentID);
				asList.add(asi);
			}

			for (AssessmentInfo asi : asList) {
				System.out.println(asi.toString());
			}
		} finally {
			DBUtils.close(cst);
		}

	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite();
		// suite.addTest( new PostgresDBTest("testQueryAssessment") );
		// suite.addTest( new PostgresDBTest("testDeleteAssessment") );

		// suite.addTest( new PostgresDBTest("testInsertAssessment") );
		// suite.addTest( new PostgresDBTest("testQueryAssessmentViaDAO") );
		suite.addTest(new PostgresDBTest("testGetAssessmentsForSubject"));
		// suite.addTest( new PostgresDBTest("testGetAssessmentIDSubject") );

		return suite;
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}

}