package clinical.test;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import junit.framework.TestSuite;
import clinical.server.vo.Experiment;
import clinical.web.Constants;
import clinical.web.IAssessmentService;
import clinical.web.ServiceFactory;
import clinical.web.actions.AsQueryHelper;
import clinical.web.common.AssessmentMapping;
import clinical.web.common.IDBCache;
import clinical.web.common.MediatedQueryHelper;
import clinical.web.common.query.BinaryOperator;
import clinical.web.common.query.Operator;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.UnaryOperator;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.helpers.ScoreValueSummaryHeader;
import clinical.web.vo.SubjectAsScoreValueSummary;

/**
 * @author I. Burak Ozyurt
 * @version $Id: QueryResultsTest.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class QueryResultsTest extends MyTestCase {
	String dbID;
	Map<Integer, List<AssessmentMapping>> siteAsMap;

	public QueryResultsTest(String testName, String propsFile)
			throws IOException {
		// don't cache DB metadata for QueryProcessor
		super(testName, propsFile, true);
		dbID = getProperty("mbirn.dbid");
	}

	protected void setUp() throws Exception {
		super.setUp();
		// String mappingFile =
		// super.props.getProperty("mediator.mapping.file");
		String mappingFile = "/home/bozyurt/dev/java/clinical/conf/as_var_map.xml";
		siteAsMap = MediatedQueryHelper.prepareAssesmentMapping(mappingFile);
	}

	public static Map<String, Experiment> toMap(List<Experiment> experiments) {
		Map<String, Experiment> map = new HashMap<String, Experiment>();
		for (Experiment exp : experiments) {
			map.put(exp.getUniqueid().toString(), exp);
		}
		return map;
	}

	protected Operator buildOpTree(List<AssessmentSelectionInfo> assessments) {
		AssessmentSelectionInfo asi = new AssessmentSelectionInfo();
		// will change every time data is reuploaded
		String MMSEAssessmentID = "1263";
		String DemographicsAssessmentID = "1264";
		String diagnosisID = "1265";

		asi.setAssessmentID(new BigDecimal(MMSEAssessmentID));
		asi.setName("MMSE");
		AsScoreInfo si1 = new AsScoreInfo(asi.getAssessmentID());
		si1.setType("integer");
		si1.setName("MMSE Score");
		asi.addScore(si1);
		assessments.add(asi);

		asi = new AssessmentSelectionInfo();
		asi.setAssessmentID(new BigDecimal(DemographicsAssessmentID));
		asi.setName("Demographics");
		AsScoreInfo si2 = new AsScoreInfo(asi.getAssessmentID());
		si2.setType("varchar");
		si2.setName("Gender");
		asi.addScore(si2);
		assessments.add(asi);

		asi = new AssessmentSelectionInfo();
		asi.setAssessmentID(new BigDecimal(diagnosisID));
		asi.setName("Diagnosis");
		AsScoreInfo si3 = new AsScoreInfo(asi.getAssessmentID());
		si3.setType("varchar");
		si3.setName("Diagnosis");
		asi.addScore(si3);
		assessments.add(asi);

		// SearchPredicate.Range range = new SearchPredicate.Range(
		// new Integer(15), new Integer(25));

		// prepare Operator tree
		/*
		 * UnaryOperator lhs = new UnaryOperator( new SearchPredicate(si1, new
		 * Integer(21) , SearchPredicate.GREATER, SearchPredicate.INTEGER),
		 * Operator.NONE);
		 */
		UnaryOperator lhs = new UnaryOperator(new SearchPredicate(si3, "A%",
				SearchPredicate.STARTS_WITH, SearchPredicate.STRING),
				Operator.NONE);

		UnaryOperator rhs = new UnaryOperator(new SearchPredicate(si2, "M",
				SearchPredicate.EQUAL, SearchPredicate.STRING), Operator.NONE);

		BinaryOperator bop = new BinaryOperator(lhs, rhs, Operator.AND);

		return bop;
	}

	protected Operator buildMultiValuedOpTree(
			List<AssessmentSelectionInfo> assessments) {
		AssessmentSelectionInfo asi = new AssessmentSelectionInfo();
		// will change every time data is reuploaded
		String test1AssessmentID = "50000";

		asi.setAssessmentID(new BigDecimal(test1AssessmentID));
		asi.setName("Test1");
		AsScoreInfo si1 = new AsScoreInfo(asi.getAssessmentID());
		si1.setType("varchar");
		si1.setName("dosage");
		asi.addScore(si1);
		assessments.add(asi);

		AsScoreInfo si2 = new AsScoreInfo(asi.getAssessmentID());
		si2.setType("integer");
		si2.setName("dailyDosage");
		asi.addScore(si2);

		// prepare Operator tree
		UnaryOperator lhs = new UnaryOperator(new SearchPredicate(si1, "*",
				SearchPredicate.STARTS_WITH, SearchPredicate.STRING),
				Operator.NONE);

		UnaryOperator rhs = new UnaryOperator(new SearchPredicate(si2, "*",
				SearchPredicate.EQUAL, SearchPredicate.INTEGER), Operator.NONE);

		BinaryOperator bop = new BinaryOperator(lhs, rhs, Operator.AND);

		return bop;
	}

	public void testQuery() throws Exception {
		IAssessmentService asService = ServiceFactory
				.getAssessmentService(dbID);
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		List<Experiment> experiments = dbCache.getExperiments(getUi(), false);
		Map<String, Experiment> expMap = toMap(experiments);

		List<SubjectAsScoreValueSummary> summaryList = null;
		List<AssessmentSelectionInfo> assessments = new ArrayList<AssessmentSelectionInfo>();
		Operator root = buildOpTree(assessments);

		summaryList = asService.queryForScores(getUi(), root, assessments,
				Constants.SEGMENT_SCOPE,"0008");
		String siteID = "TEST";
		for (Iterator<SubjectAsScoreValueSummary> iter = summaryList.iterator(); iter
				.hasNext();) {
			SubjectAsScoreValueSummary sasv = iter.next();
			sasv.setSiteID(siteID);
			System.out.println(sasv.toString());
		}

		ScoreValueSummaryHeader svHeader = new ScoreValueSummaryHeader();

		// FIXME
		Map<String, String> dbID2SiteIDMap = new HashMap<String, String>();

		AsQueryHelper.processQueryResults(summaryList, AsQueryHelper
				.toAssessmentMap(assessments, siteID), svHeader, null, null,
				dbID, getUi(), false, dbID2SiteIDMap, expMap);
	}

	public void testMultiValuedQuery() throws Exception {
		IAssessmentService asService = ServiceFactory
				.getAssessmentService(dbID);
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		List<Experiment> experiments = dbCache.getExperiments(getUi(), false);
		Map<String, Experiment> expMap = toMap(experiments);

		List<SubjectAsScoreValueSummary> summaryList = null;
		List<AssessmentSelectionInfo> assessments = new ArrayList<AssessmentSelectionInfo>();
		Operator root = buildMultiValuedOpTree(assessments);

		summaryList = asService.queryForScores(getUi(), root, assessments,
				Constants.SEGMENT_SCOPE,"0008");
		String siteID = "TEST";
		for (Iterator<SubjectAsScoreValueSummary> iter = summaryList.iterator(); iter
				.hasNext();) {
			SubjectAsScoreValueSummary sasv = iter.next();
			sasv.setSiteID(siteID);
			System.out.println(sasv.toString());
		}

		ScoreValueSummaryHeader svHeader = new ScoreValueSummaryHeader();

		// FIXME
		Map<String, String> dbID2SiteIDMap = new HashMap<String, String>();

		AsQueryHelper.processQueryResults(summaryList, AsQueryHelper
				.toAssessmentMap(assessments, siteID), svHeader, null,
				this.siteAsMap, dbID, getUi(), false, dbID2SiteIDMap, expMap);
	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite.addTest(new QueryResultsTest("testQuery", "test.properties"));
		// suite.addTest( new QueryResultsTest("testMultiValuedQuery",
		// "test.properties") );
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}
