package clinical.test;

import java.io.IOException;
import java.math.*;
import java.sql.*;
import java.util.*;

import clinical.web.*;
import junit.framework.*;
import oracle.jdbc.*;
import oracle.sql.*;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.forms.SubjectVisitManagementForm;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectAssessmentManagementTest.java,v 1.9 2005/09/09 01:52:20
 *          bozyurt Exp $
 */
public class SubjectAssessmentManagementTest extends MyTestCase {
   protected String owner;
   protected String modUser;
   protected String dbID;

   public SubjectAssessmentManagementTest(String testName, String propsFile)
         throws IOException {
      super(testName, propsFile);
      dbID = getProperty("mbirn.dbid");
   }

   public void testGetAssessmentsForSubject() throws Exception {
      ISubjectAssessmentManagement isam = ServiceFactory
            .getSubjectAssessmentManagement(dbID);

      List<AssessmentInfo> asiList = isam.getAssessmentsForSubject(getUi(),
            "000872287810", 7);
      assertTrue(asiList != null && !asiList.isEmpty());

      for (AssessmentInfo ai : asiList) {
         System.out.println(ai);
      }
   }

   public void testGetAssessmentValuesForSubject() throws Exception {
      ISubjectAssessmentManagement isam = ServiceFactory
            .getSubjectAssessmentManagement(this.dbID);

      String subjectID = "009015726375";
      List<AssessmentInfo> asiList = isam.getAssessmentsForSubject(getUi(),
            subjectID, 7);
      List<AssessmentScoreValues> asvList = isam.getAssessmentValuesForSubject(
            getUi(), subjectID, 7, asiList, 1, false);
      SubjectVisitManagementForm svmForm = new SubjectVisitManagementForm();
      svmForm.setAssessmentInfos(asiList);
      svmForm.setAsScoreValuesMap(asvList);
      svmForm.getScoreValuesDisplayLayout();
   }

   public void testTestIt() throws Exception {
      Connection con = null;
      OracleCallableStatement cst = null;
      try {
         con = getConnection();
         cst = (OracleCallableStatement) con
               .prepareCall("{call assessment_man.test_it(?)}");
         ArrayDescriptor ad = ArrayDescriptor.createDescriptor(
               "AS_ID_LIST_TYPE", con);
         BigDecimal[] as_ids = { new BigDecimal("1263") };
         ARRAY oarr = new ARRAY(ad, con, as_ids);
         // set Oracle VARRAY
         cst.setARRAY(1, oarr);
         cst.execute();

      } finally {
         if (con != null)
            releaseConnection(con);
      }
   }

   public void testGetAssessment() throws Exception {
      IAssessmentService ias = ServiceFactory.getAssessmentService(this.dbID);

      AssessmentInfo asi = ias.getAssessmentWithScores(this.getUi(), 655);
      System.out.println("asi =" + asi.toString());
   }

   public static TestSuite suite() throws IOException {
      TestSuite suite = new TestSuite();
      // suite.addTest( new SubjectAssessmentManagementTest("testTestIt",
      // "test.properties") );

      // suite.addTest( new
      // SubjectAssessmentManagementTest("testGetAssessmentValuesForSubject",
      // "test.properties") );
      // suite.addTest( new
      // SubjectAssessmentManagementTest("testGetAssessmentsForSubject",
      // "test.properties") );

      // suite.addTest( new
      // SubjectAssessmentManagementTest("testGetAssessment",
      // "test.properties") );
      suite.addTest(new SubjectAssessmentManagementTest(
            "testGetAssessmentValuesForSubject", "test.properties"));
      return suite;
   }

   public static void main(String[] args) throws IOException {
      junit.textui.TestRunner.run(suite());
   }

}
