package clinical.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import junit.framework.TestSuite;
import clinical.utils.FileUtils;
import clinical.web.IXCEDEDerivedDataService;
import clinical.web.ServiceFactory;
import clinical.web.dd.XCEDE2AnalysisImporter;
import clinical.web.services.XCEDEDerivedDataServiceImpl.MeasurementInfo;
import clinical.xml.xcede2.AnalysisT;
import clinical.xml.xcede2.MeasurementGroupT;
import clinical.xml.xcede2.XCEDE;

/**
 * @author I. Burak Ozyurt
 * @version $Id: XCEDEDDSTests.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class XCEDEDDSTests extends MyDBTestCase {

	public XCEDEDDSTests(String testName, String propsFile) throws IOException {
		super(testName, propsFile, true);
	}

	public XCEDEDDSTests(String testName) throws IOException {
		super(testName, "test.properties", true);
	}

	public void readFreesurferAnalysis() throws Exception {
		String xcedeFile = "/home/bozyurt/aseg.xml";

		JAXBContext jc = JAXBContext.newInstance(XCEDE.class);

		Unmarshaller um = jc.createUnmarshaller();
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(xcedeFile));
			XCEDE xcede = (XCEDE) um.unmarshal(in);

			for (Iterator<Object> it = xcede
					.getAnnotationListOrRevisionListOrProject().iterator(); it
					.hasNext();) {
				Object type = (Object) it.next();
				assertTrue(type instanceof AnalysisT);
				AnalysisT a = (AnalysisT) type;
				System.out.println("# of measurementGroups:"
						+ a.getMeasurementGroup().size());
				assertTrue(a.getMeasurementGroup().size() > 0);
			}
		} finally {
			FileUtils.close(in);
		}
	}

	public void testPrepData() throws Exception {
		IXCEDEDerivedDataService xdds = ServiceFactory
				.getXCEDEDerivedDataService(getDbID());

		// xdds.addTupleClass(getUi(), "nc_researchdata");
		// xdds.addTupleSubClass(getUi(), "nc_researchdata",
		// "nc_analysisresult");

		MeasurementInfo mi = new MeasurementInfo("mm3", "metric", "volume");
		// mi = new MeasurementInfo("unitless","metric", "no-unit");
		mi = new MeasurementInfo("mm^3", "metric", "volume");

		xdds.addMeasurementInfo(getUi(), mi);
	}

	public void testPopulateExtendedTuples() throws Exception {
		IXCEDEDerivedDataService xdds = ServiceFactory
				.getXCEDEDerivedDataService(getDbID());

		String xcedeFile = "/home/bozyurt/aseg.xml";

		JAXBContext jc = JAXBContext.newInstance(XCEDE.class);

		Unmarshaller um = jc.createUnmarshaller();
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(xcedeFile));
			XCEDE xcede = (XCEDE) um.unmarshal(in);
			AnalysisT a = (AnalysisT) xcede
					.getAnnotationListOrRevisionListOrProject().get(0);

			MeasurementGroupT mg = a.getMeasurementGroup().get(0);
			xdds.addExtendedTuple(getUi(),
					"Freesurfer Volumetric Measurements", mg,
					"nc_researchdata", "nc_analysisresult");

		} finally {
			FileUtils.close(in);
		}
	}

	public void testImportAnalysis() throws Exception {
		IXCEDEDerivedDataService xdds = ServiceFactory
				.getXCEDEDerivedDataService(getDbID());

		String xcedeFile = "/home/bozyurt/aseg.xml";

		JAXBContext jc = JAXBContext.newInstance(XCEDE.class);

		Unmarshaller um = jc.createUnmarshaller();
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(xcedeFile));
			XCEDE xcede = (XCEDE) um.unmarshal(in);
			AnalysisT a = (AnalysisT) xcede
					.getAnnotationListOrRevisionListOrProject().get(0);

			// specific to postgres clinical db instance

			String subjectID = "000602155404";
			Integer experimentID = new Integer(227);
			xdds.addAnalysisForSubject(getUi(), subjectID, experimentID, null,
					null, null, a, "FreeSurfer recon-all");
		} finally {
			FileUtils.close(in);
		}
	}

	public void testGetAnalysesForSubject() throws Exception {
		IXCEDEDerivedDataService xdds = ServiceFactory
				.getXCEDEDerivedDataService(getDbID());

		String subjectID = "000602155404";
		Integer experimentID = new Integer(227);
		List<AnalysisT> aList = xdds.getAnalysesForSubject(getUi(), subjectID,
				experimentID);

		XCEDE xe = new XCEDE();
		xe.getAnnotationListOrRevisionListOrProject().add(aList.get(0));

		JAXBContext jc = JAXBContext.newInstance(XCEDE.class);
		Marshaller marshaller = jc.createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, new Boolean(
				true));

		marshaller.marshal(xe, System.out);
	}

	public void testDeleteAnalysisForSubject() throws Exception {
		IXCEDEDerivedDataService xdds = ServiceFactory
				.getXCEDEDerivedDataService(getDbID());
		String subjectID = "000602155404";
		Integer experimentID = new Integer(227);

		xdds.deleteAnalysesForSubject(getUi(), subjectID, experimentID, null,
				null);
	}

	public void testDeleteExtendedTuple() throws Exception {
		IXCEDEDerivedDataService xdds = ServiceFactory
				.getXCEDEDerivedDataService(getDbID());

		xdds.deleteExtendedTuple(getUi(), "Freesurfer Volumetric Measurements");
	}

	public void testXCEDE2AnalysisImporterImport() throws Exception {
		String xcedeDir = getProperty("fsanalysis.dir");
		String shortAnalysisName = getProperty("short.analysis.name");
		String snapshotID = getProperty("snapshot.id");
		XCEDE2AnalysisImporter importer = new XCEDE2AnalysisImporter(this.mixin);
		File mergedFile = new File(xcedeDir, "merged.xml");
		importer.importFreesurferAnalyses(mergedFile.getAbsolutePath(),
				shortAnalysisName, snapshotID);
	}

	public void testXCEDE2AnalysisImporterDelete() throws Exception {
		String xcedeDir = getProperty("fsanalysis.dir");
		XCEDE2AnalysisImporter importer = new XCEDE2AnalysisImporter(this.mixin);
		File mergedFile = new File(xcedeDir, "merged.xml");
		importer.removeFreesurferAnalyses(mergedFile.getAbsolutePath());
	}

	public static TestSuite suite() throws IOException {
		TestSuite s = new TestSuite();
		// s.addTest(new XCEDEDDSTests("readFreesurferAnalysis"));
		// s.addTest(new XCEDEDDSTests("testPrepData"));
		// s.addTest(new XCEDEDDSTests("testPopulateExtendedTuples"));

		// s.addTest(new XCEDEDDSTests("testImportAnalysis"));

		// s.addTest(new XCEDEDDSTests("testGetAnalysesForSubject"));
		// s.addTest( new XCEDEDDSTests("testDeleteAnalysisForSubject"));
		// s.addTest(new XCEDEDDSTests("testDeleteExtendedTuple"));


		// s.addTest(new XCEDEDDSTests("testXCEDE2AnalysisImporterImport"));
		s.addTest(new XCEDEDDSTests("testXCEDE2AnalysisImporterDelete"));
		return s;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}
