package clinical.tools.dbadmin;

import guilib.AppFrame;

import java.awt.Font;
import java.io.File;

import javax.swing.JTabbedPane;
import javax.swing.plaf.FontUIResource;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AdminConsole.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class AdminConsole extends AppFrame {
	private static final long serialVersionUID = 6364529359107431473L;
	JTabbedPane tabbedPane;
	DataObjectTypeAdminView dotAV;
	DOAdminView doAV;
	RDAdminView rdAV;
	AdminController controller;
	State state;
	String serFile;

	public AdminConsole(int width, int height) throws Exception {
		super(width, height, new FontUIResource("Dialog", Font.PLAIN, 11));
		setTitle("Admin Tool");

		File f = new File(System.getProperty("user.home"), ".AdminTool.ser");
		serFile = f.getAbsolutePath();
		state = State.deserialize(serFile);

		controller = new AdminController(this, state);
		dotAV = new DataObjectTypeAdminView(controller);
		doAV = new DOAdminView(controller, this);
		rdAV = new RDAdminView(controller, this);

		tabbedPane = new JTabbedPane();
		tabbedPane.addTab("Data Object Registration", rdAV);
		tabbedPane.addTab("DataObjectType", dotAV);

		getContentPane().add(tabbedPane);
	}

	@Override
	public void onClose() {
		state.serialize(serFile);
		super.onClose();
	}

	public static void main(String[] args) {
		AdminConsole ac = null;
		try {
			ac = new AdminConsole(950, 750);
			ac.startup();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}
