package clinical.tools.dbadmin;

import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ListPanel.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ListPanel extends JPanel implements ListSelectionListener {
	private static final long serialVersionUID = 1;
	JTable table;
	MyTableModel tm;
	PropertyChangeSupport pcs;

	public ListPanel() {
		setLayout(new BorderLayout(5, 5));
		ArrayList<String> varNames = new ArrayList<String>(1);
		varNames.add("Column");
		ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(
				0);
		tm = new MyTableModel(varNames, data);
		table = new JTable(tm);
		JScrollPane sp = new JScrollPane(table);
		table.setFillsViewportHeight(true);
		table.setRowSelectionAllowed(true);

		add(sp, BorderLayout.CENTER);
	}

	public ListPanel(List<String> varNames, List<Map<String, Object>> data) {
		setLayout(new BorderLayout(5, 5));
		tm = new MyTableModel(varNames, data);
		table = new JTable(tm);
		JScrollPane sp = new JScrollPane(table);
		table.setFillsViewportHeight(true);
		table.setRowSelectionAllowed(true);
		table.getSelectionModel().addListSelectionListener(this);
		add(sp, BorderLayout.CENTER);

		pcs = new PropertyChangeSupport(this);

	}

	static class MyTableModel extends AbstractTableModel {
		private static final long serialVersionUID = 1L;
		List<Map<String, Object>> dataMap;
		List<String> varNames;

		public MyTableModel(List<String> varNames,
				List<Map<String, Object>> dataMap) {
			this.dataMap = dataMap;
			this.varNames = varNames;
		}

		public Map<String, Object> getDataAtRow(int rowIdx) {
			return dataMap.get(rowIdx);
		}

		public void updateModel(List<String> varNames,
				List<Map<String, Object>> dataMap) {
			this.dataMap = dataMap;
			this.varNames = varNames;
			fireTableStructureChanged();
		}

		public String getColumnName(int col) {
			return varNames.get(col);
		}

		@Override
		public int getColumnCount() {
			return varNames.size();
		}

		@Override
		public int getRowCount() {
			return dataMap.size();
		}

		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			Map<String, Object> map = dataMap.get(rowIndex);
			return map.get(varNames.get(columnIndex));
		}

	}

	@Override
	public void valueChanged(ListSelectionEvent e) {
		if (e.getValueIsAdjusting())
			return;
		int idx = table.getSelectedRow();
		System.out.println("idx:" + idx);
		if (idx >= 0) {
			Map<String, Object> row = tm.getDataAtRow(idx);
			System.out.println("row:" + row);
			pcs.firePropertyChange("record", null, row);
		}

	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		pcs.addPropertyChangeListener(listener);
	}

	public void addTableModelListener(TableModelListener l) {
		tm.addTableModelListener(l);
	}

	public boolean equals(Object obj) {
		return tm.equals(obj);
	}

	public int findColumn(String columnName) {
		return tm.findColumn(columnName);
	}

	public void fireTableCellUpdated(int row, int column) {
		tm.fireTableCellUpdated(row, column);
	}

	public void fireTableChanged(TableModelEvent e) {
		tm.fireTableChanged(e);
	}

	public void fireTableDataChanged() {
		tm.fireTableDataChanged();
	}

	public void fireTableRowsDeleted(int firstRow, int lastRow) {
		tm.fireTableRowsDeleted(firstRow, lastRow);
	}

	public void fireTableRowsInserted(int firstRow, int lastRow) {
		tm.fireTableRowsInserted(firstRow, lastRow);
	}

	public void fireTableRowsUpdated(int firstRow, int lastRow) {
		tm.fireTableRowsUpdated(firstRow, lastRow);
	}

	public void fireTableStructureChanged() {
		tm.fireTableStructureChanged();
	}

	public Class<?> getColumnClass(int columnIndex) {
		return tm.getColumnClass(columnIndex);
	}

	public int getColumnCount() {
		return tm.getColumnCount();
	}

	public String getColumnName(int col) {
		return tm.getColumnName(col);
	}

	public Map<String, Object> getDataAtRow(int rowIdx) {
		return tm.getDataAtRow(rowIdx);
	}

	public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
		return tm.getListeners(listenerType);
	}

	public int getRowCount() {
		return tm.getRowCount();
	}

	public TableModelListener[] getTableModelListeners() {
		return tm.getTableModelListeners();
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		return tm.getValueAt(rowIndex, columnIndex);
	}

	public int hashCode() {
		return tm.hashCode();
	}

	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return tm.isCellEditable(rowIndex, columnIndex);
	}

	public void removeTableModelListener(TableModelListener l) {
		tm.removeTableModelListener(l);
	}

	public void setValueAt(Object value, int rowIndex, int columnIndex) {
		tm.setValueAt(value, rowIndex, columnIndex);
	}

	public String toString() {
		return tm.toString();
	}

	public void updateModel(List<String> varNames,
			List<Map<String, Object>> dataMap) {
		tm.updateModel(varNames, dataMap);
	}
}
