package clinical.tools.install;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.InputRequest;

import clinical.web.helpers.AppConfigHelper;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AppConfigTask.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class AppConfigTask extends Task implements IUserInput {
	protected BufferedReader in;

	public AppConfigTask() {
		in = new BufferedReader(new InputStreamReader(System.in));
	}

	public String getInput(String prompt) throws IOException {
		if (in != null) {
			System.out.print(prompt);
			return in.readLine().trim();
		} else {
			InputRequest request = new InputRequest(prompt);
			project.getInputHandler().handleInput(request);
			String value = request.getInput();
			return value.trim();
		}
	}

	@Override
	public void execute() throws BuildException {
		try {
			String profile = Utils
					.getUserInput(
							"Configuration profiles allows different default configurations\n"
									+ "for different usage scenarios.\n"
									+ "birn profile is used for gridftp image storage as default\n"
									+ "local profile is used for local/mounted file system as image storage\n\n"
									+ "Please select configuration profile",
							new String[] { "birn", "local" }, this);
			System.out.println("Using profile:" + profile);
			if (profile.equalsIgnoreCase("birn")) {
				AppConfigHelper.confParamsFromXml2DB("clinical-conf.xml");
			} else {
				AppConfigHelper.confParamsFromXml2DB("local-clinical-conf.xml");
			}
		} catch (Exception x) {
			x.printStackTrace();
			throw new BuildException(x.getMessage());
		}
	}
}
