package clinical.tools.maintenance;

import clinical.server.dao.StoredassessmentDAO;
import clinical.server.vo.Storedassessment;
import clinical.web.DAOFactory;
import clinical.web.exception.BaseException;

/**
* 
* @author I. Burak Ozyurt
* @version $Id: StoredAssessmentHelper.java 62 2009-05-29 23:54:50Z bozyurt $
*/
public class StoredAssessmentHelper extends AbstractHelper {
  public StoredAssessmentHelper(String dbID, String usersFile) throws BaseException {
    super(dbID, usersFile);
  }


  public void updateSegmentID(int newSegmentID, Storedassessment criteria) throws
      Exception
  {
    Storedassessment sa = new Storedassessment();
    sa.setSegmentid(toBigDecimal(newSegmentID));
    StoredassessmentDAO dao = DAOFactory.createStoredassessmentDAO(this.dbID);
    dao.update( getConnection(),  sa, criteria);
  }

  public Storedassessment prepareCriteria( int uniqueID) {
    Storedassessment sa = new Storedassessment();
    sa.setUniqueid( toBigDecimal(uniqueID));
    return sa;
  }


  public Storedassessment prepareCriteria( int assessmentID, int visitID,
                                           int segmentID, int experimentID,
                                           int uniqueID)
  {
    Storedassessment sa = new Storedassessment();

    sa.setAssessmentid( toBigDecimal(assessmentID));
    sa.setComponentid( toBigDecimal(visitID) );
    sa.setSegmentid( toBigDecimal(segmentID));
    sa.setNcExperimentUniqueid( toBigDecimal(experimentID));
    sa.setUniqueid( toBigDecimal(uniqueID));

    return sa;
  }



}