package clinical.upload;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * @author I. Burak Ozyurt
 * @version $Id: TypeInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class TypeInfo {
	protected String name;
	protected String handlerClass;
	protected Map<String, String> properties = new HashMap<String, String>(11);
	protected IDataHandler handler;

	public TypeInfo() {
	}

	// ---------------------- setters --------------
	public void setName(String newName) {
		this.name = newName;
	}

	public void setHandlerClass(String newHandlerClass) {
		this.handlerClass = newHandlerClass;
	}

	// ---------------------- getters --------------
	public String getName() {
		return this.name;
	}

	public String getHandlerClass() {
		return this.handlerClass;
	}

	public void addProperty(String name, String value) {
		properties.put(name, value);
	}

	public Map<String, String> getProperties() {
		return properties;
	}

	public Object convertToSQL(String value, String sqlType)
			throws DataConversionException {
		try {
			if (handler == null) {
				handler = (IDataHandler) Class.forName(handlerClass)
						.newInstance();
				Class<? extends IDataHandler> clazz = handler.getClass();
				Iterator<Map.Entry<String,String>> iter = properties.entrySet().iterator();
				while (iter.hasNext()) {
					Map.Entry<String,String> entry = iter.next();
					setProperty(clazz, handler, entry.getKey(),
							entry.getValue());
				}
			}

			return handler.convertToSQL(value, sqlType);

		} catch (Exception x) {
			if (x instanceof DataConversionException)
				throw (DataConversionException) x;
			x.printStackTrace();
			throw new DataConversionException(x.getMessage());
		}
	}

	public static void setProperty(Class<? extends IDataHandler> hClazz,
			Object aHandler, String property, String value) throws Exception {
		Method method = hClazz.getMethod(getSetterName(property),
				new Class[] { String.class });
		method.invoke(aHandler, new Object[] { value });

	}

	public static String getGetterName(String property) {
		StringBuffer buf = new StringBuffer();
		buf.append("get");
		char[] carr = property.toCharArray();
		buf.append(Character.toUpperCase(carr[0]));
		for (int i = 1; i < carr.length; i++) {
			buf.append(carr[i]);
		}
		return buf.toString();
	}

	public static String getSetterName(String property) {
		StringBuffer buf = new StringBuffer();
		buf.append("set");
		char[] carr = property.toCharArray();
		buf.append(Character.toUpperCase(carr[0]));
		for (int i = 1; i < carr.length; i++) {
			buf.append(carr[i]);
		}
		return buf.toString();
	}

}