package clinical.upload.conditioner;

import java.util.HashMap;
import java.util.Map;

import clinical.upload.ColumnInfo;
import clinical.utils.GenUtils;

/**
 *
 * used when the raw data needs filtering more involved than
 * type conversion, one-to one mapping
 * the conditioner methods can be arbitarly complex
 * the necessary parameters (if any) are passed via second argument
 *
 * @version $Id: GenConditioner.java 62 2009-05-29 23:54:50Z bozyurt $
 * @author I. Burak Ozyurt
 */

public class GenConditioner {
  protected Map<String, String> cvltColMap = new HashMap<String, String>();

  public GenConditioner() {
    String[] cvltVars = {
        "CVL0115R", "CVL0115S", "CVL011R", "CVL011S", "CVL015R", "CVL015S",
        "CVL01BR", "CVL01BS", "CVL01SFR",
        "CVL01SFS", "CVL01SCR", "CVL01SCS", "CVL01LFR", "CVL01LFS", "CVL01LCR",
        "CVL01LCS", "CVL01RHR", "CVL01RHS", "CVL01RFR",
        "CVL01RFS", "CVL01RBR", "CVL01RBS", "CVL01RDS", "CVL01SDS"};
    for (int i = 0; i < cvltVars.length; i++) {
      cvltColMap.put(cvltVars[i], cvltVars[i]);
    }
  }


  public Object conditionMMSE(String value, Object params) {
    if (value.equalsIgnoreCase("n/a"))
      return null;

    return value;
  }


  // all negative values are assumed to be defaults
  public Object conditionDefaultValue(String value, Object params) {
    if (value == null)
        return null;

    Number num = GenUtils.toNumber(value);
    if (num == null)
      return value;

    if (params != null && num != null) {
      ColumnInfo ci = (ColumnInfo) params;
      if (num.intValue() < 0) {
        if (cvltColMap.get(ci.getName()) != null) {
          // only -99 is no good for CVLT !
          return (num.intValue() == -99) ? null : value;
        } else {
          // not a CVLT variable must not have a value
          return null;
        }
      }
    } else if (num != null) {
      // negative values are no good!
      if (num.intValue() < 0) {
        return null;
      }
    }
    return value;
  }
}