package clinical.utils;

import clinical.web.download.FileInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: BIRNURIUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class BIRNURIUtils {
	public final static String LOCAL_SCHEME = "local";
	public final static String SRB_SCHEME = "srb";

	public static String getScheme(String uri) throws BIRNURIException {
		int idx = uri.indexOf("://");
		if (idx == -1) {
			throw new BIRNURIException("No BIRN URI scheme for URI:" + uri);
		} else {
			String scheme = uri.substring(0, idx);
			if (!scheme.equals(LOCAL_SCHEME) && !scheme.equals(SRB_SCHEME)) {
				throw new BIRNURIException("Unsupported BIRN URI scheme:"
						+ scheme);
			}
			return scheme;
		}
	}

	public static String getPath(String uri) throws BIRNURIException {
		int idx = uri.indexOf("://");
		if (idx == -1) {
			throw new BIRNURIException("No BIRN URI scheme for URI:" + uri);
		} else {
			String path = uri.substring(idx + 3);
			return path;
		}
	}
	
	public static boolean hasSchemePart(String uri) {
		return uri.indexOf("://") != -1;
	}

	public static boolean isSRBScheme(String uri) {
		try {
			String scheme = getScheme(uri);
			return scheme.equals(SRB_SCHEME);
		} catch (BIRNURIException e) {
			System.err.println(e);
			return false;
		}
	}

	public static boolean isLocalScheme(String uri) {
		try {
			String scheme = getScheme(uri);
			return scheme.equals(LOCAL_SCHEME);
		} catch (BIRNURIException e) {
			System.err.println(e);
			return false;
		}
	}

	public static void main(String[] args) throws BIRNURIException {
		System.out.println(getScheme("srb:///home/Projects/etc"));
		System.out.println(getPath("srb:///home/Projects/etc"));
		System.out.println(getScheme("unknown:///home/Projects/etc"));

	}

	public static String addScheme(String path, int storageType) {
		int idx = path.indexOf("://");
		if (idx == -1) {
			switch (storageType) {
			case FileInfo.SRB:
				return SRB_SCHEME + "://" + path;
			case FileInfo.LOCAL:
				return LOCAL_SCHEME + "://" + path;
			default:
               throw new RuntimeException("Unrecognized storage type: " + storageType);
			}
		}
		return path;
	}
}
