package clinical.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ColumnTypeChanger.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ColumnTypeChanger {
	boolean TEST = false;

	public ColumnTypeChanger() {
	}

	public void changeColumnType(Connection con, String schema,
			String tableName, String columnName, String columnType)
			throws SQLException {
		List<ColumnInfo> colInfos = getColumnInfos(con, tableName);
		boolean foundColumn = false;
		StringBuffer buf = new StringBuffer(1000);
		buf.append("create table t_backup (");
		for (Iterator<ColumnInfo> iter = colInfos.iterator(); iter.hasNext();) {
			ColumnInfo ci = iter.next();
			if (columnName.equalsIgnoreCase(ci.name))
				foundColumn = true;

			buf.append(ci.name).append(" ").append(ci.dataType);
			if (ci.dataType.equalsIgnoreCase("float")
					|| ci.dataType.equalsIgnoreCase("float")) {
				buf.append('(').append(ci.precision).append(',').append(
						ci.scale).append(")");
			} else if (ci.dataType.equalsIgnoreCase("varchar2")
					|| ci.dataType.equalsIgnoreCase("char")) {
				buf.append('(').append(ci.dataLength).append(')');
			}
			if (iter.hasNext())
				buf.append(", ");
		}
		buf.append(")");
		if (!foundColumn) {
			System.err.println("The column " + columnName + " is not found in "
					+ tableName);
			return;
		}
		System.out.println(buf.toString());
		String createTableSQL = buf.toString();

		buf = new StringBuffer(1000);
		buf.append("insert into t_backup select ");
		for (Iterator<ColumnInfo> iter = colInfos.iterator(); iter.hasNext();) {
			ColumnInfo ci = iter.next();
			buf.append(ci.name);
			if (iter.hasNext())
				buf.append(", ");
		}
		buf.append(" from ").append(tableName);

		System.out.println(buf.toString());

		Map<String, ForeignKey> fkMap = getForeignKeys(con, schema.toUpperCase(), tableName
				.toUpperCase());

		writeForeignKeys(fkMap, System.getProperty("user.home")
				+ File.separator + tableName + "fk.sql");

		// dropt the foreign keys
		for (Iterator<ForeignKey> iter = fkMap.values().iterator(); iter.hasNext();) {
			ForeignKey fk = iter.next();
			String sql = fk.toDropForeignKey();
			executeSQL(con, sql);
		}

		if (TEST)
			return;

		// boolean autoCommit = con.getAutoCommit();
		con.setAutoCommit(false);
		try {

			executeSQL(con, createTableSQL);
			// copy data to backup table
			executeSQL(con, buf.toString());

			// remove all data from original table
			executeSQL(con, "delete from " + tableName);

			// change column
			executeSQL(con, "alter table " + tableName + " modify ( "
					+ columnName + " " + columnType + ")");

			copyRows(con, tableName, colInfos);

			// put pack foreign keys
			/*
			 * for (Iterator iter = fkMap.values().iterator(); iter.hasNext(); ) {
			 * ForeignKey fk = (ForeignKey)iter.next(); String sql =
			 * fk.toForeignKey(); executeSQL(con, sql); }
			 */
			if (areAllRowsSame(con, tableName)) {
				// remove backup table
				executeSQL(con, "drop table t_backup");
			}

			con.commit();
		} catch (SQLException x) {
			con.rollback();
			throw x;
		} finally {
			con.setAutoCommit(true);
		}

	}

	void writeForeignKeys(Map<String, ForeignKey> fkMap, String filename) {
		BufferedWriter out = null;
		try {
			String newFilename = GenUtils.getUniqueFile(filename);
			File f = new File(filename);
			f.renameTo(new File(newFilename));

			out = new BufferedWriter(new FileWriter(filename));

			for (Iterator<ForeignKey> iter = fkMap.values().iterator(); iter.hasNext();) {
				ForeignKey fk = iter.next();
				String sql = fk.toForeignKey();
				out.write(sql);
				out.newLine();
			}

			out.newLine();

			for (Iterator<ForeignKey> iter = fkMap.values().iterator(); iter.hasNext();) {
				ForeignKey fk = iter.next();
				String sql = fk.toDropForeignKey();
				out.write(sql);
				out.newLine();
			}

		} catch (Exception x) {
			x.printStackTrace();
		} finally {
			if (out != null)
				try {
					out.close();
				} catch (Exception x) {
				}
		}
	}

	protected boolean areAllRowsSame(Connection con, String tableName)
			throws SQLException {
		List<Object[]> backupRows = getAllRows(con, "t_backup");
		List<Object[]> rows = getAllRows(con, tableName);
		if (backupRows.size() != rows.size())
			return false;
		Iterator<Object[]> it = rows.iterator();
		for (Iterator<Object[]> iter = backupRows.iterator(); iter.hasNext();) {
			Object[] backupRow = iter.next();
			Object[] row = it.next();
			for (int i = 0; i < backupRow.length; i++) {
				if (!backupRow[i].toString().equals(row[i].toString()))
					return false;
			}
		}

		return true;
	}

	protected List<Object[]> getAllRows(Connection con, String tableName)
			throws SQLException {
		List<Object[]> rows = new LinkedList<Object[]>();
		Statement st = null;
		try {
			st = con.createStatement();
			StringBuffer buf = new StringBuffer(128);
			buf.append("select * from ").append(tableName);
			ResultSet rs = st.executeQuery(buf.toString());
			ResultSetMetaData rsmd = rs.getMetaData();
			while (rs.next()) {
				Object[] row = new Object[rsmd.getColumnCount()];
				for (int i = 0; i < rsmd.getColumnCount(); i++) {
					row[i] = rs.getObject(i + 1);
				}
				rows.add(row);
			}
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
		return rows;
	}

	public void copyRows(Connection con, String tableName, List<ColumnInfo> colInfos)
			throws SQLException {
		StringBuffer buf = new StringBuffer(1000);
		buf.append("select ");
		for (Iterator<ColumnInfo> iter = colInfos.iterator(); iter.hasNext();) {
			ColumnInfo ci = iter.next();
			buf.append(ci.name);
			if (iter.hasNext())
				buf.append(", ");
		}
		buf.append(" from t_backup");
		String query = buf.toString();

		buf = new StringBuffer(1000);
		buf.append("insert into ").append(tableName).append(" (");
		for (Iterator<ColumnInfo> iter = colInfos.iterator(); iter.hasNext();) {
			ColumnInfo ci = iter.next();
			buf.append(ci.name);
			if (iter.hasNext())
				buf.append(", ");
		}
		buf.append(") values(");
		for (Iterator<ColumnInfo> iter = colInfos.iterator(); iter.hasNext();) {
			iter.next();
			buf.append('?');
			if (iter.hasNext())
				buf.append(", ");
		}
		buf.append(")");
		String insertSql = buf.toString();

		System.out.println("query=" + query);
		System.out.println("insertSql =" + insertSql);

		List<Object[]> rows = new LinkedList<Object[]>();
		Statement st = null;
		ResultSet rs = null;
		try {
			st = con.createStatement();
			rs = st.executeQuery(query);
			while (rs.next()) {
				Object[] row = new Object[colInfos.size()];
				for (int i = 0; i < row.length; i++) {
					row[i] = rs.getObject(i + 1);
				}
				rows.add(row);
			}

		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
		PreparedStatement pst = null;
		try {
			pst = con.prepareStatement(insertSql);

			for (Iterator<Object[]> iter = rows.iterator(); iter.hasNext();) {
				Object[] row = iter.next();
				pst.clearParameters();
				for (int i = 0; i < row.length; i++) {
					// System.out.println("setting "+ i + " col " + row[i]);
					if (row[i] != null) {
						pst.setObject(i + 1, row[i]);
					} else
						pst.setNull(i + 1, Types.VARCHAR);
				}
				pst.execute();
			}

		} finally {
			if (pst != null)
				try {
					pst.close();
				} catch (Exception x) {
				}
		}

	}

	public void executeSQL(Connection con, String sql) throws SQLException {
		Statement st = null;
		try {
			st = con.createStatement();
			st.execute(sql);
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}

	}

	public Map<String, ForeignKey> getForeignKeys(Connection con, String schema, String tableName)
			throws SQLException {
		DatabaseMetaData md = con.getMetaData();
		ResultSet rs = md.getExportedKeys(null, schema, tableName);
		Map<String, ForeignKey> fkMap = new LinkedHashMap<String, ForeignKey>();
		while (rs.next()) {
			// System.out.println("pk column="+ rs.getObject(4));
			// System.out.println("fk table="+ rs.getObject(7));
			// System.out.println("fk column="+ rs.getObject(7));

			String pkColumn = rs.getObject(4).toString();
			String pkTable = rs.getObject(3).toString();
			String fkTable = rs.getObject(7).toString();
			String fkColumn = rs.getObject(8).toString();
			int deleteRule = rs.getShort(11);
			String pkName = rs.getString(13);
			String fkName = rs.getString(12);
			int keySeq = rs.getShort(9);

			ForeignKey fk = (ForeignKey) fkMap.get(pkTable + fkTable);
			if (fk == null) {
				fk = new ForeignKey(fkName, pkName, pkTable, fkTable, 10,
						deleteRule);
				fkMap.put(pkTable + fkTable, fk);
			}
			fk.addFkColumn(fkColumn, keySeq - 1);
			fk.addPkColumn(pkColumn, keySeq - 1);

		}
		System.out.println("imported keys");
		rs = md.getImportedKeys(null, schema, tableName);

		while (rs.next()) {
			String pkColumn = rs.getObject(4).toString();
			String pkTable = rs.getObject(3).toString();
			String fkTable = rs.getObject(7).toString();
			String fkColumn = rs.getObject(8).toString();
			int deleteRule = rs.getShort(11);
			String pkName = rs.getString(13);
			String fkName = rs.getString(12);
			int keySeq = rs.getShort(9);

			ForeignKey fk = fkMap.get(pkTable + fkTable);
			if (fk == null) {
				fk = new ForeignKey(fkName, pkName, pkTable, fkTable, 10,
						deleteRule);
				fkMap.put(pkTable + fkTable, fk);
			}
			fk.addFkColumn(fkColumn, keySeq - 1);
			fk.addPkColumn(pkColumn, keySeq - 1);

			// System.out.println("pk table ="+ rs.getObject(3));
			// System.out.println("pk column="+ rs.getObject(4));
			// System.out.println("fk table="+ rs.getObject(7));
			// System.out.println("fk column="+ rs.getObject(8));
		}
		for (Iterator<ForeignKey> iter = fkMap.values().iterator(); iter.hasNext();) {
			ForeignKey fk = iter.next();
			System.out.println(fk.toForeignKey());

		}
		return fkMap;
	}

	public List<ColumnInfo> getColumnInfos(Connection con, String tableName)
			throws SQLException {
		String sql = "select  column_name, data_type, data_length, nullable,data_precision, data_scale from user_tab_cols where table_name='";
		sql += tableName.toUpperCase() + "'";
		List<ColumnInfo> colInfos = new LinkedList<ColumnInfo>();
		Statement st = null;
		ResultSet rs = null;
		try {
			st = con.createStatement();
			rs = st.executeQuery(sql);
			while (rs.next()) {
				ColumnInfo ci = new ColumnInfo();
				ci.name = rs.getString(1);
				ci.dataType = rs.getString(2);
				ci.dataLength = rs.getInt(3);
				ci.nullable = rs.getString(4).equalsIgnoreCase("y");
				ci.precision = rs.getInt(5);
				ci.scale = rs.getInt(6);
				colInfos.add(ci);
			}
		} finally {
			if (rs != null)
				try {
					rs.close();
				} catch (Exception x) {
				}
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
		return colInfos;
	}

	class ColumnInfo {
		String name;
		String dataType;
		int dataLength;
		boolean nullable;
		int precision;
		int scale;
	}

	class ForeignKey {
		String name;
		String pkName;
		String pkTable;
		String fkTable;
		String[] pkColumns;
		String[] fkColumns;
		int deleteRule;
		String updateRule;
		int colCount = 0;

		public ForeignKey(String fkName, String pkName, String pkTable,
				String fkTable, int maxCols, int deleteRule) {
			this.name = fkName;
			this.pkName = pkName;
			this.pkTable = pkTable;
			this.fkTable = fkTable;
			pkColumns = new String[maxCols];
			fkColumns = new String[maxCols];
			this.deleteRule = deleteRule;
		}

		public void addPkColumn(String colName, int idx) {
			pkColumns[idx] = colName;
		}

		public void addFkColumn(String colName, int idx) {
			fkColumns[idx] = colName;
		}

		public int getColumnCount() {
			for (int i = 0; i < fkColumns.length; i++) {
				if (fkColumns[i] == null)
					return i;
			}
			return fkColumns.length;
		}

		public String toForeignKey() {
			colCount = getColumnCount();
			StringBuffer buf = new StringBuffer(256);
			buf.append("alter table ").append(fkTable).append(
					" add constraint ").append(name);
			buf.append(" foreign key (");
			for (int i = 0; i < colCount; i++) {
				buf.append(fkColumns[i]);
				if ((i + 1) < colCount)
					buf.append(',');
			}
			buf.append(") references ").append(pkTable).append('(');
			for (int i = 0; i < colCount; i++) {
				buf.append(pkColumns[i]);
				if ((i + 1) < colCount)
					buf.append(',');
			}
			buf.append(")");

			return buf.toString();
		}

		public String toDropForeignKey() {
			StringBuffer buf = new StringBuffer(256);
			buf.append("alter table ").append(fkTable).append(
					" drop constraint ").append(name);

			return buf.toString();
		}
	}

	public void changeColumnTypes(Connection con, String schema,
			Properties props) throws SQLException {
		int idx = 1;
		boolean finished = false;
		while (!finished) {
			String tableNamePropName = "table" + idx + ".name";
			String tableName = props.getProperty(tableNamePropName);
			if (tableName == null)
				break;
			String columNamePropName = "table" + idx + ".column";
			String columnName = props.getProperty(columNamePropName);
			if (columnName == null)
				break;
			String columnTypePropName = "table" + idx + ".columntype";
			String colType = props.getProperty(columnTypePropName);
			if (colType == null)
				break;
			System.out.println("changing column " + columnName + " for table "
					+ tableName + "...");
			changeColumnType(con, schema.toUpperCase(), tableName, columnName,
					colType);
			++idx;
		}
	}

	public static void main(String[] args) {
		Properties props;
		Connection con = null;
		try {
			props = GenUtils.loadProperties("dbutils.properties");
			String dbURL = props.getProperty("dburl");
			String user = props.getProperty("user");
			String pwd = props.getProperty("pwd");
			Class.forName("oracle.jdbc.driver.OracleDriver");

			con = DriverManager.getConnection(dbURL, user, pwd);

			ColumnTypeChanger ct = new ColumnTypeChanger();

			ct.changeColumnTypes(con, user, props);

			// ct.changeColumnType(con, "UCSD_FMRI", "nc_ontologyconcept",
			// "conceptid", "varchar2(64)");
			// ct.changeColumnType(con, "UCSD_FMRI", "nc_assessmentscore",
			// "assessmentconcept", "varchar2(64)");

			// ct.changeColumnType(con, "UCSD_FMRI", "nc_researchdata",
			// "dataclass", "varchar2(64)");
			// ct.changeColumnType(con, "UCSD_FMRI", "nc_researchdata",
			// "conceptid", "varchar2(64)");

		} catch (Exception x) {
			x.printStackTrace();
		} finally {
			if (con != null)
				try {
					con.close();
				} catch (Exception x) { /* ignore */
				}
		}

	}
}