package clinical.utils;

import java.util.ArrayList;
import java.util.List;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: JargonUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class JargonUtils {

	/**
	 * given a valid srb collection path, returns all files under that
	 * collection found at any depth of the collection hierarchy rooted at
	 * <code>rootSRBPath</code>
	 *
	 * @param rootSRBPath
	 * @param sfsAdapter
	 * @return a list of {@link edu.sdsc.grid.io.GeneralFile} objects.
	 * @throws Exception
	 */
	public static List<GeneralFile> getAllFilesUnderCollection(
			String rootSRBPath, SRBFileSystemAdapter sfsAdapter)
			throws Exception {
		SRBFile srbFile = new SRBFile(sfsAdapter.getNewSrbFileSystem(),
				rootSRBPath);

		List<GeneralFile> paths = new ArrayList<GeneralFile>();
		GeneralFile[] files = srbFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				paths.add(files[i]);
			} else {
				prepBranch(files[i], paths);
			}
		}

		return paths;
	}

	protected static void prepBranch(GeneralFile parentDir,
			List<GeneralFile> paths) {
		GeneralFile[] files = parentDir.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				paths.add(files[i]);
			} else {
				prepBranch(files[i], paths);
			}
		}
	}

	public static List<String> getAllFilesUnderCollection2(String rootSRBPath,
			SRBFileSystemAdapter sfsAdapter) throws Exception {
		SRBFile srbFile = new SRBFile(sfsAdapter.getSrbFileSystem(),
				rootSRBPath);

		List<String> paths = new ArrayList<String>();
		GeneralFile[] files = srbFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				paths.add(files[i].getAbsolutePath());
			} else {
				prepBranch2(files[i], paths);
			}
		}
		return paths;
	}

	protected static void prepBranch2(GeneralFile parentDir, List<String> paths) {
		GeneralFile[] files = parentDir.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				paths.add(files[i].getAbsolutePath());
			} else {
				prepBranch2(files[i], paths);
			}
		}
	}

	public static final void copyFromSRB(String srbPath, String localPath,
			SRBFileSystemAdapter sfsAdapter) throws Exception {
       copyFromSRB(srbPath, localPath, sfsAdapter, 3);
	}

	public static final void copyFromSRB(String srbPath, String localPath,
			SRBFileSystemAdapter sfsAdapter, int retryCount) throws Exception {
		LocalFile lf = new LocalFile(localPath);
		int count = 0;
		boolean ok = false;
		while (!ok) {
			try {
				GeneralFile srbFile = new SRBFile(
						sfsAdapter.getSrbFileSystem(), srbPath);
				// force overwrite
				srbFile.copyTo(lf, true);
				System.out.println(srbPath + " copied to " + lf.getAbsolutePath());
				ok = true;
				++count;
			} catch (Exception e) {
				System.err.println(e);
				if (count >= retryCount) {
					throw e;
				} else {
					System.out.println("retrying for the " + (count + 1)
							+ ". time for srbPath: " + srbPath);
				}
			}
		}
	}
}
