package clinical.utils;

import java.io.File;
import java.util.Properties;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ProcessUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ProcessUtils {

protected ProcessUtils() {}
	
	public static Executor prepareExecutor(Properties props) {
		String home = props.getProperty("proc.env.home");
		String path = props.getProperty("proc.env.path");
		String dcmPath = props.getProperty("proc.env.dcmpath");
		String pwd = props.getProperty("proc.env.pwd");
		String perl5lib = props.getProperty("proc.env.perl5lib");
		String perlExec = props.getProperty("perl_executable");
		String matlabPath = props.getProperty("proc.env.matlabpath");

		Executor executor = new Executor(perlExec, true);
		executor.addEnvParam("PATH", path);
		executor.addEnvParam("HOME", home);
		executor.addEnvParam("DCMDICTPATH", dcmPath);
		executor.addEnvParam("PERL5LIB", perl5lib);
		executor.addEnvParam("PWD", pwd);
		if ( matlabPath != null) {
			executor.addEnvParam("MATLABPATH", matlabPath);
		}

		return executor;
	}

	public static String prepareScript(Properties props, String scriptName) {
		String scriptPath = props.getProperty("script_path");
		StringBuffer buf = new StringBuffer(96);
		if (scriptPath != null) {
			buf.append(scriptPath).append(File.separator).append(scriptName);
		} else
			buf.append(scriptName);
		return buf.toString();
	}

}
