package clinical.web.actions;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.UserInfo;
import clinical.web.download.ImageSeriesDataInfo;
import clinical.web.forms.SubjectVisitForm;
import clinical.web.services.IDownloadJobService;
import clinical.web.services.SecurityService;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ImageSeriesViewerDataAction.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ImageSeriesViewerDataAction extends BaseAction {
   private Log log = LogFactory.getLog(ImageSeriesViewerDataAction.class);
   public static final String REL_VIEWER_IMAGES_PATH = "/viewer/";

   public ActionForward execute(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      log.info("execute");
      try {
         UserInfo ui = getUserInfo(request);
         HttpSession session = request.getSession(false);
         SubjectVisitForm svForm = (SubjectVisitForm) session
               .getAttribute(Constants.SUBVISIT_FORM_KEY);
         String siteID = svForm.getSiteID();
         int visitID = GenUtils.toInt(request.getParameter("visitID"), -1);
         int segID = GenUtils.toInt(request.getParameter("segID"), -1);

         String dbID = (String) session
               .getAttribute(Constants.SESSION_DBID_KEY);

         IAuthenticationService authService = ServiceFactory
               .getAuthenticationService();
         SecurityService ss = (SecurityService) ServiceFactory
               .getSecurityService();
         String theDBID = ss.findDBForSiteID(siteID);
         if (theDBID != dbID) {
            log.info("theDBID=" + theDBID);
            ui = authService.getDefaultUser(theDBID, ui);            
         }
         VisitSegment vs = null;
         for (Visit v : svForm.getClinicalVisits()) {
            if (v.getComponentID() == visitID) {
               vs = v.getVisitSegment(segID);
            }
         }
         if (vs == null) {
            for (Visit v : svForm.getScanVisits()) {
               if (v.getComponentID() == visitID) {
                  vs = v.getVisitSegment(segID);
               }
            }
         }
         ImageSeriesDataInfo isdi = null;
         File[] jpegFiles = null;
         
         String cacheRoot = REL_VIEWER_IMAGES_PATH;
         cacheRoot = session.getServletContext().getRealPath(cacheRoot);
         new File(cacheRoot).mkdirs();
         if (vs != null) {
            IDownloadJobService djs = ServiceFactory.getDownloadJobService();
            isdi = vs.getIsdi();

            jpegFiles = djs.downloadAndPrepareImageSeries(isdi, cacheRoot, ui);
         }

         JSONObject js = new JSONObject();
         if (isdi != null) {
            js.put("siteID", siteID);
            js.put("subjectID", isdi.getSubjectID());
            js.put("experiment", isdi.getExpName());
            js.put("visit", isdi.getVisitID());
            js.put("segment", isdi.getSegmentID());
         }
         JSONArray jsArr = new JSONArray();
         js.put("jpegs", jsArr);
         if (jpegFiles != null) {
            // sort jpeg files in slice order
            Arrays.sort(jpegFiles, new Comparator<File>() {
               public int compare(File o1, File o2) {
                  String prefix1 = o1.getName();
                  prefix1 = prefix1.replaceFirst("\\..+$", "");
                  String prefix2 = o2.getName();
                  prefix2 = prefix2.replaceFirst("\\..+$", "");
                  int num1 = GenUtils.toInt(prefix1, -1);
                  int num2 = GenUtils.toInt(prefix2, -1);
                  return num1 - num2;
               }
            });
            for (File file : jpegFiles) {
               String baseName = file.getName();
               String parentDir = file.getParentFile().getName();
               StringBuilder sb = new StringBuilder();
               sb.append(REL_VIEWER_IMAGES_PATH).append(parentDir);
               sb.append('/').append(baseName);
               String imagePath = sb.toString();
               if (imagePath.startsWith("/"))
                  imagePath = imagePath.replaceFirst("^\\/+", "../");
               jsArr.put(imagePath);
            }
         }
         response.setContentType("application/json");
         String jsonStr = js.toString();
         log.info("jsonStr:" + jsonStr);
         response.getOutputStream().println(jsonStr);
         return null;

      } catch (Exception x) {
         log.error("execute", x);
         JSONObject js = new JSONObject();
         JSONArray jsArr = new JSONArray();
         js.put("jpegs", jsArr);
         response.setContentType("application/json");
         String jsonStr = js.toString();
         response.getOutputStream().println(jsonStr);
      }

      return null;
   }
}
