package clinical.web.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Assessment;
import clinical.utils.GenUtils;
import clinical.utils.HTTPUtils;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.SessionStateCoordinator;
import clinical.web.UserContainer;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.UserInfo;
import clinical.web.exception.UnknownUserException;
import clinical.web.forms.LogonForm;
/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: LogonAction.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class LogonAction extends BaseAction {
	private Log log = LogFactory.getLog(LogonAction.class);
	private final static boolean USE_SINGLE_SIGNON_IMITATION = false;

	public LogonAction() {
	}	

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		String callbackPath = mapping.getModuleConfig().getPrefix()
				+ request.getContextPath();
		callbackPath += Constants.LOGINHANDLER;

		callbackPath = GenUtils.createServerURI(request.getScheme(), request
				.getServerName(), request.getServerPort(), callbackPath);

		log.info("CALLBACKPATH=" + callbackPath);

		// MessageResources resources = this.getResources(request);
		// check via the Authentication Service, if the user has the right
		// credentials
		IAuthenticationService authService = ServiceFactory
				.getAuthenticationService();

		LogonForm lgForm = (LogonForm) form;
		String userName = lgForm.getUsername();
		String pwd = lgForm.getPassword();
		String dbID = lgForm.getLoginDBSelector().getSelectedDatabase();

		// log.info("userName="+ userName + ",pwd=" + pwd + ",dbID=" + dbID);
		if (dbID == null) {
			dbID = ServiceFactory.getSecurityService().getDefaultDBID();
			log.debug("The database id selected:" + dbID);
		}
		System.out.println(">>>> The database id selected:" + dbID);

		HttpSession session = request.getSession(false);
		if (session != null)
			session.invalidate();

		UserInfo ui = null;
		if (log.isDebugEnabled())
			log.debug("authenticating the user " + userName);
		try {
			if (!lgForm.isInPublicMode()) {
				ui = authService.authenticate(userName, pwd, dbID);
			} else {
				// public mode
				ui = authService.authenticateAnonymous(userName, dbID);
			}
			if (log.isDebugEnabled())
				log.debug("The user " + userName + " is authenticated!");

			// create a new session
			session = request.getSession(true);
			UserContainer userCon = new UserContainer(ui, dbID);

			session.setAttribute(Constants.CONTAINER_KEY, userCon);
			session.setAttribute(Constants.SESSION_DBID_KEY, dbID);

			// precache the assessment info
			/*
			IAssessmentService asService = ServiceFactory
					.getAssessmentService(dbID);
			List<Assessment> assessments = asService.getAllAssessments(ui);
			cacheAssessmentNames(assessments, session);
			*/
			
			// set the session state coordinator to control menu items and/or
			// buttons based on the current state
			SessionStateCoordinator ssc = new SessionStateCoordinator(dbID);
			session.setAttribute(Constants.SESSION_STATE_COORDINATOR_KEY, ssc);

			if (log.isDebugEnabled()) {
				String contents = HTTPUtils.dumpSessionContents(session);
				log.debug(contents);
			}

		} catch (Exception x) {
			if (USE_SINGLE_SIGNON_IMITATION
					&& x instanceof UnknownUserException) {
				// try portal login
				try {
					ActionForward af = tryPortalLogin(mapping, request,
							userName, pwd, callbackPath);
					log.info("actionForward=" + af);
					return af;
				} catch (Exception ex) {
					log.debug("processing exception " + ex);
					return processExceptions(request, response, mapping, form,
							x);
				}
			}
			log.info("processing exception " + x.getMessage());
			lgForm.setErrMessage(x.getMessage());
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	protected void cacheAssessmentNames(List<Assessment> assessments, HttpSession session) {
		Map<String, String> assessmentNameMap = new HashMap<String, String>(31);

		for (Assessment as : assessments) {
			assessmentNameMap.put(as.getName(), as.getName());
		}
		session.setAttribute(Constants.ASSESSMENT_NAME_MAP,
				assessmentNameMap);	
	}
	
	protected ActionForward tryPortalLogin(ActionMapping mapping,
			HttpServletRequest request, String user, String pwd,
			String callbackPath) throws Exception {
		request.setAttribute("user", user);
		request.setAttribute("pass", pwd);
		request.setAttribute("loginhandler", callbackPath);

		return mapping.findForward(Constants.TO_PORTAL);
	}

}
