package clinical.web.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.web.Constants;
import clinical.web.IAssessmentService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.helpers.QueryWizardHelper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SelectScoresAction.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class SelectScoresAction extends BaseLookupDispatchAction {
	protected Map<String, String> buttonMap = new HashMap<String, String>(5);
	private static Log log = LogFactory.getLog(SelectScoresAction.class);

	public SelectScoresAction() {
	}

	protected Map<String, String> getKeyMethodMap() {
		buttonMap.put("button.continue", "nextPage");
		buttonMap.put("button.previous", "prevPage");
		buttonMap.put("button.expand", "expand");
		buttonMap.put("button.collapse", "collapse");

		return buttonMap;
	}

	public ActionForward expand(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			String key = queryForm.getExpandCollapseKey();
			if (key != null) {
				AsScoreInfo si = findScore(queryForm, key);
				// QueryWizardHelper qwHelper = new QueryWizardHelper();
				// qwHelper.dumpScoresForAssessment(si, queryForm);

				si.expand();
			}
			queryForm.setState(Constants.COLLAPSE_EXPAND);
			return mapping.findForward(Constants.COLLAPSE_EXPAND);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward collapse(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			String key = queryForm.getExpandCollapseKey();
			log.info("expandCollapseKey=" + key);
			if (key != null) {
				QueryWizardHelper qwHelper = new QueryWizardHelper();
				qwHelper.populateScores(request, queryForm);

				AsScoreInfo si = findScore(queryForm, key);
				si.collapse();
				// qwHelper.dumpScoresForAssessment(si, queryForm);
			}
			queryForm.setState(Constants.COLLAPSE_EXPAND);
			return mapping.findForward(Constants.COLLAPSE_EXPAND);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private AsScoreInfo findScore(AsQueryBuilderForm queryForm, String key)
			throws NumberFormatException {
		int idx = key.indexOf('_');
		int asIdx = Integer.parseInt(key.substring(0, idx));
		int scoreIdx = Integer.parseInt(key.substring(idx + 1));

		AssessmentSelectionInfo asi = (AssessmentSelectionInfo) queryForm
				.getAssessments().get(asIdx);
		AsScoreInfo si = asi.getScore(scoreIdx);
		return si;
	}

	public ActionForward nextPage(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		// Locale locale = this.getLocale(request);
		// MessageResources messages = this.getResources(request);
		log.debug("**** SelectScoresAction");

		IAssessmentService asService = null;
		IDBCache dbCache = null;
		QueryWizardHelper qwHelper = new QueryWizardHelper();

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);
			dbCache = ServiceFactory.getDBCache(dbID);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			String state = queryForm.getState();
			log.info("SelectScoresAction state=" + state);

			if (!queryForm.getState().equals(Constants.SEL_SCORE)
					&& !queryForm.getState().equals(Constants.COLLAPSE_EXPAND)) {
				log.debug("%%%%% cannot process!");
				throw new BaseException("", "wizard.out_of_order");
			}

			qwHelper.validateSelectScores(queryForm, request);

			QueryWizardHelper.prepareExperimentSelector(ui, queryForm, dbCache);

			List<AssessmentSelectionInfo> asiList = qwHelper.populateScores(request, queryForm);
			boolean hasSubcorticalData = false;

			if (queryForm.getSavedQueryLoaded()) {
				hasSubcorticalData = qwHelper
						.hasSubcorticalVariables(queryForm);

				// create a list of QueryPartInfo objects and store them in the
				// ASQueryBuilderForm
				qwHelper.createQueryParts(queryForm, asiList);

				qwHelper.prepareRangeInfos(ui, queryForm, asService, false);

				// retrieve score codes and set the appropriate enumerations
				qwHelper.prepareEnumerations(ui, queryForm, dbCache);
			} else {
				// prepare the subcortical variables for next page
				hasSubcorticalData = qwHelper.prepareSubcorticalVariables(dbID,
						ui, queryForm);

				// create a list of QueryPartInfo objects and store them in the
				// ASQueryBuilderForm
				qwHelper.createQueryParts(queryForm, asiList);

				// retrieve range info from the database and associate them with
				// the corresponding query part (for scores only)
				qwHelper.prepareRangeInfos(ui, queryForm, asService, false);

				// retrieve score codes and set the appropriate enumerations
				qwHelper.prepareEnumerations(ui, queryForm, dbCache);
			}

			// for the next step
			if (hasSubcorticalData) {
				log.info("forwarding to " + Constants.SEL_DERIVED);
				queryForm.setState(Constants.SEL_DERIVED);
				return mapping.findForward(Constants.SEL_DERIVED);
			} else {
				log.info("forwarding to " + Constants.COLLECT_QUERY);
				queryForm.setState(Constants.COLLECT_QUERY);
				return mapping.findForward(Constants.TO_COLLECT_QUERY);
			}

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward prevPage(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;

			QueryWizardHelper qwHelper = new QueryWizardHelper();
			qwHelper.populateScores(request, queryForm);

			queryForm.setState(Constants.SEL_ASSESSMENT);

			return mapping.findForward(Constants.SEL_ASSESSMENT);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public void cleanupAfterException(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, BaseException be) {
		((AsQueryBuilderForm) form).clean();
	}

}
