package clinical.web.actions;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.VisitInfo;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Rawdata;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ISubjectAssessmentManagement;
import clinical.web.ISubjectVisitHandler;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ImageHandler;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.download.DataNode;
import clinical.web.download.FileInfo;
import clinical.web.download.ImageSeriesDataInfo;
import clinical.web.download.SubjectImageDataBundle;
import clinical.web.exception.BaseException;
import clinical.web.exception.ImageHandlerException;
import clinical.web.forms.SubjectVisitForm;
import clinical.web.services.IDownloadJobService;
import clinical.web.services.SecurityService;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.CollectionEquipment;
import clinical.web.vo.StudySegmentInfo;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * for SubjectVisit.jsp.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectVisitAction.java,v 1.23.6.1 2009/01/16 20:53:29 bozyurt
 *          Exp $
 */

public class SubjectVisitAction extends BaseAction {
	private Log log = LogFactory.getLog(SubjectVisitAction.class);

	public SubjectVisitAction() {}

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		ISubjectVisitHandler handler = null;
		IDBPoolService pool = null;
		Connection con = null;
		UserInfo ui = null;
		try {
			UserInfo userInfo = getUserInfo(request);
			IAuthenticationService authService = ServiceFactory
					.getAuthenticationService();

			HttpSession session = request.getSession(false);
			String subjectID = (String) request.getParameter("sid");
			String siteID = (String) request.getParameter("siteid");
			log.debug("got sid=" + subjectID);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			SecurityService ss = (SecurityService) ServiceFactory
					.getSecurityService();
			// String theDBID = GenUtils.getDBIDFromSiteID(siteID, dbID);
			String theDBID = ss.findDBForSiteID(siteID);

			assert (theDBID != null);
			if (theDBID != dbID) {
				log.info("theDBID=" + theDBID);
				ui = authService.getDefaultUser(theDBID, userInfo);
			} else {
				ui = userInfo;
			}

			// get the corresponding database query
			pool = ServiceFactory.getPoolService(theDBID);
			con = pool.getConnection(ui.getName());

			handler = ServiceFactory.getSubjectVisitHandler();

			SubjectVisitForm svForm = (SubjectVisitForm) form;
			// cleanup old data
			svForm.clearState();

			svForm.setSiteID(siteID);
			svForm.setSubjectID(subjectID);
			if (log.isDebugEnabled()) {
				log.debug("getting visitInfos");
			}

			List<VisitInfo> visitInfos = handler.getVisitInfos(theDBID, con,
					subjectID);

			if (log.isDebugEnabled()) {
				log.debug("got visit infos size=" + visitInfos.size());
			}

			IDownloadJobService djs = ServiceFactory.getDownloadJobService();
			IAppConfigService configService = ServiceFactory.getAppConfigService();
			String[] subjectIDArr = new String[] { subjectID };
			String expID = String.valueOf(visitInfos.get(0).getVisit()
					.getNcExperimentUniqueid());
			// FIXME only DICOM images
			String[] specifiedObjectTypes = new String[] { "3_SRB COL DICOM",
					"3_LOC COL DICOM", "3_SRB FILE DICOM", "3_LOC FILE DICOM",
					"3_GFTP COL DICOM", "3_GFTP FILE DICOM" };

			SubjectImageDataBundle sidb = new SubjectImageDataBundle(subjectID,
					siteID, null);
			SubjectImageDataBundle[] sidbArr = new SubjectImageDataBundle[] { sidb };

			djs.prepImagePathsForSubject(siteID, theDBID, ui, subjectIDArr, expID,
					sidbArr, null, configService, specifiedObjectTypes);

			BigDecimal scanVisitID = null;
			BigDecimal scanExpID = null;
			List<Visit> visitList = new ArrayList<Visit>(visitInfos.size());
			for (VisitInfo vi : visitInfos) {
				Visit v = toVisit(vi, dbID, ui, subjectID);
				visitList.add(v);

				SubjectAssessmentInfo sai = prepareAssessmentData(theDBID, ui,
						subjectID, vi.getVisit().getNcExperimentUniqueid().intValue());

				if (sai != null) {
					List<VisitSegment> segments = v.getVisitSegments();
					for (VisitSegment vs : segments) {
						int noAssessments = vs.findAndSetAssessmentInfos(sai.asiList);
						if (noAssessments > 0) {
							vs.setAsScoreValuesMap(sai.valuesList);
						}
					}
				}

				if (vi.getVisit().getVisittype().startsWith(
						Constants.VISIT_TYPE_SCAN)) {
					svForm.addScanVisit(v);
					scanVisitID = vi.getVisit().getComponentid();
					scanExpID = vi.getVisit().getNcExperimentUniqueid();
					List<Expsegment> scanVisitSegments = vi.getSegments();
					for (Expsegment segment : scanVisitSegments) {
						VisitSegment vs = v.getVisitSegment(segment.getSegmentid()
								.intValue());
						Collectionequipment ce = vi.getEquipment(segment);
						if (ce != null) {
							CollectionEquipment eq = new CollectionEquipment(ce
									.getMake(), ce.getModel());
							vs.setEquipment(eq);
						}
					}
				} else {
					svForm.addClinicalVisit(v);
				}
			}

			// if there are any structural data of recognized type
			// prepare data structures for viewer
			prepare4Viewer(visitList, sidbArr[0], siteID);

			boolean allowMriDownload = GenUtils.toBoolean(configService
					.getParamValue(Constants.ALLOW_MRI_DOWNLOAD_PROPERTY), false);
			svForm.setAllowMRIDownload(allowMriDownload);

			if (allowMriDownload) {
				preparePreviewSlice(con, session, subjectID, svForm, scanVisitID,
						scanExpID);
			}

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			if (pool != null)
				pool.releaseConnection(ui.getName(), con);
		}
	}

	protected void prepare4Viewer(List<Visit> visitList,
			SubjectImageDataBundle sidb, String siteID) {

		for (Visit visit : visitList) {
			List<VisitSegment> sisList = findStructuralImageSegments(visit
					.getVisitSegments());
			for (VisitSegment seg : sisList) {
				String expID = String.valueOf(visit.getExperimentID());
				String expName = sidb.getExperimentName(expID);
				String visitID = String.valueOf(visit.getComponentID());
				String segmentID = String.valueOf(seg.getSegmentID());

				List<DataNode> dnList = sidb.findBySegment(visit.getSubjectID(),
						expName, visit.getComponentID(), seg.getName());

				Assertion.assertTrue(dnList == null || dnList.size() <= 1);
				DataNode dn = (dnList == null || dnList.isEmpty()) ? null : dnList
						.get(0);

				if (dn != null) {
					FileInfo fi = (FileInfo) dn.getUserObject();
					ImageSeriesDataInfo isdi = new ImageSeriesDataInfo(fi, expID,
							expName, visit.getSubjectID(), siteID, visitID, segmentID);
					seg.setIsdi(isdi);
				}
			}
		}
	}

	protected List<VisitSegment> findStructuralImageSegments(
			List<VisitSegment> segments) {
		List<VisitSegment> sisList = new ArrayList<VisitSegment>(3);
		for (VisitSegment seg : segments) {
			if (seg.getName().equalsIgnoreCase("t1")
					|| seg.getName().equalsIgnoreCase("t2")
					|| seg.getName().equalsIgnoreCase("t1_deface")) {
				sisList.add(seg);
			}
		}

		return sisList;
	}

	private void preparePreviewSlice(Connection con, HttpSession session,
			String subjectID, SubjectVisitForm svForm, BigDecimal scanVisitID,
			BigDecimal scanExpID) throws BaseException {
		// prepare the jpeg for slice 50
		ImageHandler imgHandler = ServiceFactory.getImageHandlerService();
		try {
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			List<Rawdata> rawDatas = imgHandler.getRawDataForSubject(dbID, con,
					subjectID, scanVisitID, scanExpID, null);
			if (rawDatas.size() == 1) {
				String jpegDirName = (String) session.getServletContext()
						.getAttribute(Constants.MRI_JPEGS_DIR_KEY);
				String jpegDirPath = session.getServletContext().getRealPath(
						jpegDirName);
				log.debug("jpegDirPath=" + jpegDirPath);
				Rawdata rawData = (Rawdata) rawDatas.get(0);

				log.info("SubjectID=" + subjectID + " dataURI="
						+ rawData.getDatauri() + "\njpegDirPath=" + jpegDirPath);

				String jpegFileName = imgHandler.convertToJpeg(subjectID, rawData
						.getDatauri(), Constants.DICOM_SLICE, jpegDirPath);

				svForm.setImageName(jpegDirName + "/" + jpegFileName);
			} else {
				svForm.setImageName(Constants.NO_PICTURE_JPEG);
			}
		} catch (ImageHandlerException ihx) {
			svForm.setImageName(Constants.NO_PICTURE_JPEG);
		}
	}

	protected Visit toVisit(VisitInfo vi, String dbID, UserInfo ui,
			String subjectID) throws BaseException {
		Visit v = new Visit(vi.getVisit());

		// retrieve study information if any for this subject
		List<String> subjectIDList = new ArrayList<String>(1);
		subjectIDList.add(subjectID);
		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(dbID);
		List<StudySegmentInfo> studySegmentInfoList = isvm
				.findStudyInfosForSubjects(ui, subjectIDList);
		Map<String, StudySegmentInfo> ssiMap = new HashMap<String, StudySegmentInfo>(
				7);
		for (StudySegmentInfo ssi : studySegmentInfoList) {
			String key = AsQueryHelper.createStudySegmentInfoKey(ssi
					.getSubjectID(), ssi.getExperimentID(), ssi.getVisitID(), ssi
					.getSegmentID());
			ssiMap.put(key, ssi);
		}

		List<Expsegment> segs = vi.getSegments();
		for (Expsegment s : segs) {
			VisitSegment vs = new VisitSegment(s);
			if (!ssiMap.isEmpty()) {
				// set study information if any
				String key = AsQueryHelper.createStudySegmentInfoKey(vs
						.getSubjectID(), vs.getExperimentID(), vs.getVisitID(), vs
						.getSegmentID());
				StudySegmentInfo ssi = ssiMap.get(key);
				if (ssi != null) {
					vs.setStudyID(ssi.getStudyID());
					vs.setStudyName(ssi.getStudyName());
				}
			}
			v.addVisitSegment(vs);
		}
		return v;
	}

	protected SubjectAssessmentInfo prepareAssessmentData(String dbID,
			UserInfo ui, String subjectID, int experimentID) throws BaseException {
		ISubjectAssessmentManagement isam = null;
		isam = ServiceFactory.getSubjectAssessmentManagement(dbID);
		SubjectAssessmentInfo sai = null;
		List<AssessmentInfo> asiList = isam.getAssessmentsForSubject(ui,
				subjectID, experimentID);

		if (asiList != null && !asiList.isEmpty()) {
			// get only validated assessment values
			List<AssessmentScoreValues> valuesList = isam
					.getAssessmentValuesForSubject(ui, subjectID, experimentID,
							asiList, -1, true);
			sai = new SubjectAssessmentInfo(asiList, valuesList);
		}
		return sai;
	}

	static public class SubjectAssessmentInfo {
		List<AssessmentInfo> asiList;
		List<AssessmentScoreValues> valuesList;

		public SubjectAssessmentInfo(List<AssessmentInfo> asiList,
				List<AssessmentScoreValues> valuesList) {
			this.asiList = asiList;
			this.valuesList = valuesList;
		}
	}
}
