package clinical.web.common;

import java.util.HashMap;
import java.util.Map;

import org.ietf.jgss.GSSCredential;

/**
 * 
 * @version $Id: UserInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 * @author I. Burak Ozyurt
 */

public class UserInfo implements java.io.Serializable {
	private static final long serialVersionUID = -497049932290818753L;
	final private String name;
	private String email;
	private String[] roles;
	private GSSCredential credential;
	private Map<String, String> availableTables = new HashMap<String, String>();

	public UserInfo(String name, String[] roles,
			Map<String, String> availableTables) {
		this.name = name;
		this.roles = roles;
		this.availableTables = availableTables;
	}
	
	
	public UserInfo(String name, String[] roles,
			Map<String, String> availableTables, GSSCredential credential) {
		this.name = name;
		this.roles = roles;
		this.availableTables = availableTables;
		this.credential = credential;
	}

	public UserInfo(final String name, final String email, String[] roles,
			Map<String, String> availableTables) {
		this.name = name;
		this.roles = roles;
		this.availableTables = availableTables;
		this.email = email;
	}

	// ---------------------- getters --------------
	public String getName() {
		return this.name;
	}

	public String getPerceivedName() {
		if (email != null) {
			return email;
		}
		return name;
	}

	public String[] getRoles() {
		return roles;
	}

	public boolean isTableAvailable(String tableName) {
		return availableTables.get(tableName) != null;
	}

	public Map<String, String> getAvailableTables() {
		return this.availableTables;
	}

	public String getEmail() {
		return email;
	}


	public GSSCredential getCredential() {
		return credential;
	}
}