package clinical.web.common.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: VisitSegAnalysisResultValues.java,v 1.1.2.1 2008/07/03 21:46:56
 *          bozyurt Exp $
 */
public class VisitSegAnalysisResultValues implements Serializable {
	private static final long serialVersionUID = 1L;
	private int visitID;
	private int segmentID;
	private int expID;
	private String siteID;
	private int studyID = -1;
	private String studyName;
	private String timeStamp;
	private Map<ARValueKey, Object> valueMap = new LinkedHashMap<ARValueKey, Object>(
			7);
	private Map<String, ARValueKey> arvKeyMap = null;
	private List<Row<ValueWrapper>> rows;
	private int numberOfCols = 2;

	public VisitSegAnalysisResultValues(int visitID, int segmentID, int expID,
			String siteID) {
		this(visitID, segmentID, expID, siteID, -1, null);
	}

	public VisitSegAnalysisResultValues(int visitID, int segmentID, int expID,
			String siteID, int studyID, String studyName) {
		super();
		this.visitID = visitID;
		this.segmentID = segmentID;
		this.expID = expID;
		this.siteID = siteID;
		this.studyID = studyID;
		this.studyName = studyName;
	}

	public void addValue(ARValueKey key, Object value) {
		valueMap.put(key, value);
	}

	/**
	 *
	 * @param mgName
	 * @param fieldName
	 *            (aka observationName)
	 * @return
	 */
	public Object getValue(String mgName, String fieldName) {
		if (arvKeyMap == null) {
			arvKeyMap = new HashMap<String, ARValueKey>(7);
			for (ARValueKey arvKey : valueMap.keySet()) {
				String key = arvKey.getMgName() + ":" + arvKey.getFieldName();
				arvKeyMap.put(key, arvKey);
			}
		}
		String key = mgName + ":" + fieldName;
		ARValueKey arvKey = arvKeyMap.get(key);
		if (arvKey != null) {
			return valueMap.get(arvKey);
		}
		return null;
	}

	public int getVisitID() {
		return visitID;
	}

	public int getSegmentID() {
		return segmentID;
	}

	public int getExpID() {
		return expID;
	}

	public String getSiteID() {
		return siteID;
	}

	public int getStudyID() {
		return studyID;
	}

	public String getStudyName() {
		return studyName;
	}

	public String getTimeStamp() {
		return timeStamp;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + expID;
		result = prime * result + segmentID;
		result = prime * result + ((siteID == null) ? 0 : siteID.hashCode());
		result = prime * result + visitID;
		return result;
	}

	public Map<ARValueKey, Object> getValueMap() {
		return valueMap;
	}

	public List<Row<ValueWrapper>> getRows() {
		if (rows == null) {
			int count = 0;
			String curETName = null;
			Row<ValueWrapper> row = null;
			rows = new ArrayList<Row<ValueWrapper>>(valueMap.size()
					/ numberOfCols + 1);
			List<ARValueKey> sortedList = getSortedKeyList();
			for (ARValueKey key : sortedList) {
				if (curETName == null
						|| !curETName.equals(key.getExtendedTupleName())) {
					curETName = key.getExtendedTupleName();
					row = new Row<ValueWrapper>(new ArrayList<ValueWrapper>(1),
							numberOfCols);
					row.addColumn(new ValueWrapper(new KeyView(key, true), ""));
					rows.add(row);
					count = 0;
				}
				if (count == numberOfCols) {
					count = 0;
				}
				if (count == 0) {
					row = new Row<ValueWrapper>(new ArrayList<ValueWrapper>(
							numberOfCols), numberOfCols);
					rows.add(row);
				}
				Object value = valueMap.get(key);

				row.columns.add(new ValueWrapper(new KeyView(key,false), value));
				count++;
			}

		}
		return rows;
	}

	protected List<ARValueKey> getSortedKeyList() {
		List<ARValueKey> list = new ArrayList<ARValueKey>(valueMap.keySet());
		Collections.sort(list, new Comparator<ARValueKey>() {

			@Override
			public int compare(ARValueKey o1, ARValueKey o2) {
				int cv = o1.getExtendedTupleName().compareTo(
						o2.getExtendedTupleName());
				if (cv == 0) {
					cv = o1.getMgName().compareTo(o2.getMgName());
					if (cv == 0)
						return o1.getFieldName().compareTo(o2.getFieldName());
				}
				return cv;
			}
		});
		return list;
	}

	public static class KeyView extends ARValueKey implements Serializable {
		private static final long serialVersionUID = 1L;
		protected boolean title;

		public KeyView(ARValueKey key, boolean title) {
			super(key.getAnExTupleInfo(), key.getMgName(), key.getFieldName(),
					key.getEtID());
			this.title = title;
		}

		public boolean isTitle() {
			return title;
		}
	}//;

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final VisitSegAnalysisResultValues other = (VisitSegAnalysisResultValues) obj;
		if (expID != other.expID)
			return false;
		if (segmentID != other.segmentID)
			return false;
		if (siteID == null) {
			if (other.siteID != null)
				return false;
		} else if (!siteID.equals(other.siteID))
			return false;
		if (visitID != other.visitID)
			return false;
		return true;
	}

	/**
	 * toString method: creates a String representation of the object
	 *
	 * @return the String representation
	 */
	public String toString() {
		StringBuilder buffer = new StringBuilder();
		buffer.append("VisitSegAnalysisResultValues::[");
		buffer.append("expID = ").append(expID);
		buffer.append(", segmentID = ").append(segmentID);
		buffer.append(", siteID = ").append(siteID);
		buffer.append(", visitID = ").append(visitID);
		for (Map.Entry<ARValueKey, Object> entry : valueMap.entrySet()) {
			buffer.append("\n\t").append(entry.getKey()).append(" => ").append(
					entry.getValue());
		}
		buffer.append("]");
		return buffer.toString();
	}

	public static class ValueWrapper implements Serializable {
		private static final long serialVersionUID = 1L;
		ARValueKey key;
		Object value;

		public ValueWrapper() {
		}

		public ValueWrapper(ARValueKey key, Object value) {
			super();
			this.key = key;
			this.value = value;
		}

		public ARValueKey getKey() {
			return key;
		}

		public Object getValue() {
			return value;
		}

		public boolean isEmptyObject() {
			return value == null;
		}
	}// ;

	public void setTimeStamp(String timeStamp) {
		this.timeStamp = timeStamp;
	}
}
