package clinical.web.download;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: FileBundleConfig.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class FileBundleConfig {
    protected String bundleName;
    protected String cacheDir;
    protected String sourceRootDir;
    // source files
    protected List<FileInfo> fileInfoList = new LinkedList<FileInfo>();
    protected long totalSize = -1; // in bytes
    
    protected int action;
    protected long cacheAge;
    
    public final static int TARRED = 1;
    public final static int GZIPPED = 2;
    
	public FileBundleConfig(int action, String name, String cacheDir) {
		super();
		this.action = action;
		bundleName = name;
		this.cacheDir = cacheDir;
	}

	public long getTotalSize() {
		if ( totalSize < 0) {
			for(FileInfo fi : fileInfoList) {
				totalSize += fi.getFileSize();
			}
		}
		return totalSize;
	}
	
	
	public void addFileInfo(FileInfo fi) {
		fileInfoList.add(fi);
	}
	

	public int getAction() {
		return action;
	}

	public String getBundleName() {
		return bundleName;
	}

	public long getCacheAge() {
		return cacheAge;
	}

	public String getCacheDir() {
		return cacheDir;
	}

	public List<FileInfo> getFileInfoList() {
		return fileInfoList;
	}

	
	public boolean hasSRBFiles() {
		for (Iterator<FileInfo> iter = fileInfoList.iterator(); iter.hasNext();) {
			FileInfo fi = iter.next();
            if ( fi.getStorageType() == FileInfo.SRB) {			
            	return true;
            }
		}	
		return false;
	}
	
	public boolean hasLocalFiles() {
		for(FileInfo fi : fileInfoList) {
			if ( fi.getStorageType() == FileInfo.LOCAL) {
				return true;
			}
		}
		return false;
	}
	
	public boolean hasGridFtpFiles() {
		for (Iterator<FileInfo> iter = fileInfoList.iterator(); iter.hasNext();) {
			FileInfo fi = iter.next();
            if ( fi.getStorageType() == FileInfo.GRIDFTP) {			
            	return true;
            }
		}	
		return false;
	}
	
	public List<FileBundleConfig> split(long maxBundleSize) {
		List<FileBundleConfig> fbcList = new ArrayList<FileBundleConfig>(10);
		int idx = 0;
		long sum = 0;
		List<FileInfo> fiList = new ArrayList<FileInfo>();
		for(Iterator<FileInfo> it = fileInfoList.iterator(); it.hasNext();) {
			FileInfo fi = it.next();
			sum += fi.getFileSize();
			fiList.add(fi);
			if ( sum >= maxBundleSize) {
				String bn = bundleName+ "_" + idx;
				FileBundleConfig fbc = new FileBundleConfig(action, bn, cacheDir);
				fbc.fileInfoList = fiList;
				fbcList.add(fbc);
				fiList = new ArrayList<FileInfo>();
				sum = 0;
				idx++;
			} else if (!it.hasNext()) {
				String bn = bundleName+ "_" + idx;				
				FileBundleConfig fbc = new FileBundleConfig(action, bn, cacheDir);
				fbc.fileInfoList = fiList;
				fbcList.add(fbc);
				
			}
		}
		if ( fbcList.size() == 1) {
			FileBundleConfig fbc = fbcList.get(0);
			fbc.bundleName = fbc.bundleName.replaceFirst("_\\d+$", "");
		}
		return fbcList;
	}
}
