package clinical.web.download;

import clinical.utils.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ImageSeriesDataInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ImageSeriesDataInfo {
   protected String expName;
   protected String expID;
   protected String subjectID;
   protected String siteID;
   protected String visitID;
   protected String segmentID;
   protected String rootLocation;
   protected String imageDirName;
   protected FileInfo fileInfo;

   public FileInfo getFileInfo() {
      return fileInfo;
   }

   public ImageSeriesDataInfo(FileInfo fileInfo, String expID, String expName,
         String subjectID, String siteID, String visitID, String segmentID) {
      this.fileInfo = fileInfo;
      this.expName = expName;
      this.expID = expID;
      this.subjectID = subjectID;
      this.siteID = siteID;
      this.visitID = visitID;
      this.segmentID = segmentID;

   }

   public ImageSeriesDataInfo(String rootLocation, String expName,
         String expID, String subjectID, String siteID, String visitID,
         String segmentID, String imageDirName) {
      super();
      this.rootLocation = rootLocation;
      this.expName = expName;
      this.expID = expID;
      this.subjectID = subjectID;
      this.siteID = siteID;
      this.visitID = visitID;
      this.segmentID = segmentID;
      this.imageDirName = imageDirName;
   }

   public String getURL() {
      StringBuilder sb = new StringBuilder(128);
      sb.append(rootLocation).append('/');
      sb.append(subjectID).append('/');
      sb.append("scanVisit__").append(siteID).append('_').append(
            GenUtils.leftPad(visitID, '0', 4 - visitID.length()));
      sb.append("/MRI_0001/").append(segmentID).append('/');
      sb.append("/Native/Original_0001/");
      sb.append(imageDirName);

      return sb.toString();
   }

   public String getExpName() {
      return expName;
   }

   public String getExpID() {
      return expID;
   }

   public String getSubjectID() {
      return subjectID;
   }

   public String getSiteID() {
      return siteID;
   }

   public String getVisitID() {
      return visitID;
   }

   public String getSegmentID() {
      return segmentID;
   }

   public String getRootLocation() {
      return rootLocation;
   }

}
