package clinical.web.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.web.helpers.StoredQueryInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: StoredQuerySelector.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class StoredQuerySelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> storedQueries;
	protected int selectedQueryID;

	public StoredQuerySelector() {
	}

	public StoredQuerySelector(List<StoredQueryInfo> sqiList) {
		storedQueries = new ArrayList<LabelValueBean>(sqiList.size());
		boolean first = true;
		for (StoredQueryInfo sqi : sqiList) {
			LabelValueBean lvb = new LabelValueBean(sqi.getDescription(),
					String.valueOf(sqi.getQueryID()));
			storedQueries.add(lvb);
			if (first) {
				selectedQueryID = sqi.getQueryID();
				first = false;
			}
		}
	}

	public void setStoredQueries(Collection<LabelValueBean> sqList) {
		this.storedQueries = sqList;
	}

	public Collection<LabelValueBean> getStoredQueries() {
		return (Collection<LabelValueBean>) this.storedQueries;
	}

	public Collection<LabelValueBean> getSavedQueries() {
		return (Collection<LabelValueBean>) this.storedQueries;
	}

	public String getStoredQueries(int queryID) {
		String qidStr = String.valueOf(queryID);
		for (Iterator<LabelValueBean> it = storedQueries.iterator(); it
				.hasNext();) {
			LabelValueBean lvb = it.next();
			if (lvb.getValue().equals(qidStr))
				return lvb.getLabel();
		}
		return null;
	}

	public void setSelectedQueryID(int newSelectedQueryID) {
		this.selectedQueryID = newSelectedQueryID;
	}

	public int getSelectedQueryID() {
		return this.selectedQueryID;
	}

}
