package clinical.web.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;
import clinical.server.vo.Protocol;
import clinical.utils.GenUtils;
import clinical.web.helpers.PropertyQueryPartInfo;
import clinical.web.helpers.ScoreValuesDisplayHelper;
import clinical.web.helpers.ScoreValuesDisplayLayout;
import clinical.web.helpers.SearchResultsIterator;
import clinical.web.helpers.SegmentFormInfo;
import clinical.web.helpers.SegmentTimestampSelector;
import clinical.web.helpers.StudyFormInfo;
import clinical.web.helpers.StudySelector;
import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.helpers.SubjectManagementHelper;
import clinical.web.helpers.VisitFormInfo;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.Subject;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SubjectVisitManagementForm.java,v 1.27.2.1 2007/06/28 01:48:06
 *          bozyurt Exp $
 */

public class SubjectVisitManagementForm extends ActionForm {
	private static final long serialVersionUID = -5070631077459353695L;
	/** the subject managed */
	protected Subject subject;
	private String[] combinators;
	/** */
	protected String selectedSubjectID;
	/** the current visit id */
	protected String selectedVisitID;
	protected String selectedSegmentID;
	protected String selectedStudyID;

	/** the visit that is active (currently processed) */
	protected VisitFormInfo currentVisit;
	protected List<String> visitTypes;
	/**
	 * holds a list of <code>clinical.server.vo.Protocol</code> objects from
	 * the database
	 */
	protected List<Protocol> protocols = new LinkedList<Protocol>();
	/**
	 * holds a list of <code>clinical.server.vo.Experiment</code> objects from
	 * the database
	 */
	protected List<Experiment> experiments = new LinkedList<Experiment>();
	/** holds a list of visit date values for subject management screen */
	protected List<LabelValueBean> visitDateLVBeans = new LinkedList<LabelValueBean>();
	/** holds the date of the shown visit */
	protected String visitDateValue;
	protected List<LabelValueBean> allSubjectLVBeans = new LinkedList<LabelValueBean>();
	/** */
	protected String segmentTimestampValue;
	/**
	 * holds a list of segment timestamp label value beans for segment date drop
	 * down
	 */
	// protected List segmentTsLVBeans = new LinkedList();
	protected SearchResultsIterator searchResultsIter = null;
	protected List<PropertyQueryPartInfo> queryParts = new ArrayList<PropertyQueryPartInfo>();
	protected List<Subject> subjectSummaryList;

	protected SegmentTimestampSelector segTimestampSelector;

	/**
	 * holds a list of <code>clinical.web.vo.AssessmentInfo</code> objects for
	 * the current subject
	 */
	protected List<AssessmentInfo> assessmentInfos;
	protected List<AssessmentInfo> curAsInfos;
	/**
	 * holds a map of assessment name versus
	 * <code>clinical.web.vo.AssessmentScoreValues</code> objects for the
	 * current subject
	 */
	protected Map<String, AssessmentScoreValues> asScoreValuesMap;
	int maxScoreNumber = -1;
	int currentAsIdx = 0;
	/**
	 * holds the subject ID for the subject double clicked in the subject search
	 * page (see <code>SubjectSearch.jsp</code>)
	 */
	protected String selectedSubjectValue;
	/**
	 * holds the action type (Add Visit, Update Visit, Add Segment/Update
	 * Segment)
	 */
	protected String currentAction;

	protected SegmentFormInfo currentSegment;
	/** holds a list of experiment name/experiment ID label value beans */
	protected List<LabelValueBean> experimentLVBeans = new LinkedList<LabelValueBean>();
	/** holds the experiment ID of the selected experiment */
	protected String experimentValue;

	/** for the assessment selection dropdown */
	protected AssessmentSelector editableAssessmentSelector;
	protected List<String> allEditableAsNames;
	/** the name of the assessment selected for editing */
	protected String selectedAsNameForEdit;

	protected StudySelector studySelector;
	protected SubjectExperimentsSelector expSelector;
	/** num of entries keyed by the assessment ID */
	protected Map<String, Integer> entryMap = new HashMap<String, Integer>(23);
	/** used to indicate the assessment entry to retrieve */
	protected String selectedEntryID = null;
	/** assessment reconciliation status keyed by the assessment ID */
	protected Map<String, String> reconStatsMap = new HashMap<String, String>(
			23);

	protected SubjectExperimentsSelector enrollExperimentSelector;
	protected String exp2RGListJSON = "{}";
	protected String selectedResearchGroupId;

	public final static String READY_FOR_RECON = "ready";
	public final static String NOT_READY_FOR_RECON = "not_ready";
	public final static String RECONCILED = "reconciled";

	private Log log = LogFactory.getLog(SubjectVisitManagementForm.class);

	public SubjectVisitManagementForm() {
		this.subject = new Subject("");
		PropertyQueryPartInfo pqp = new PropertyQueryPartInfo("subjectID",
				"Subject ID", false);
		addQueryPart(pqp);
	}

	/**
	 * called whenever previously held state excluding the subject managed needs
	 * to be cleaned
	 */
	public void cleanState() {
		this.currentVisit = null;

		this.currentAction = null;
		if (visitTypes != null)
			this.visitTypes.clear();
		this.protocols = null;
		if (experiments != null)
			this.experiments.clear();
		this.visitDateValue = null;
		if (allSubjectLVBeans != null)
			this.allSubjectLVBeans.clear();
		this.segmentTimestampValue = null;
		if (segTimestampSelector != null)
			this.segTimestampSelector = null;
		if (visitDateLVBeans != null)
			this.visitDateLVBeans.clear();

		this.subjectSummaryList = null;

		this.assessmentInfos = null;
		this.curAsInfos = null;
		if (asScoreValuesMap != null)
			this.asScoreValuesMap.clear();
		this.selectedSubjectValue = null;
		this.currentAsIdx = 0;
		this.maxScoreNumber = -1;
		this.currentSegment = null;
		if (experimentLVBeans != null)
			this.experimentLVBeans.clear();
		this.experimentValue = null;
		this.editableAssessmentSelector = null;
		if (allEditableAsNames != null)
			this.allEditableAsNames.clear();
		this.selectedAsNameForEdit = null;
		this.studySelector = null;
		this.selectedStudyID = null;
		this.expSelector = null;
	}

	public List<AssessmentInfo> getAssessmentInfos() {
		return assessmentInfos;
	}

	/**
	 * Whenever the current visit and segment id is changed this needs to be
	 * called
	 */
	public void setCurrentAsInfos() {
		int selVisitID = Integer.parseInt(getSelectedVisitID());
		int selSegmentID = Integer.parseInt(getSelectedSegmentID());
		curAsInfos = new LinkedList<AssessmentInfo>();
		if (assessmentInfos == null) {
			return;
		}
		reconStatsMap.clear();
		for (AssessmentInfo asi : assessmentInfos) {
			if (asi.getVisitID() == selVisitID
					&& asi.getSegmentID() == selSegmentID) {
				if (asi.getScores().isEmpty()) {
					log.error("No scores for asi:" + asi);
				}
				curAsInfos.add(asi);
				setReconStatus(String.valueOf(asi.getAssessmentID()),
						NOT_READY_FOR_RECON);
			}
		}
	}

	public void removeFromCurrentAsInfos(AssessmentInfo asi2BeRemoved) {
		curAsInfos.remove(asi2BeRemoved);
	}

	public List<AssessmentInfo> getAssessmentInfosForCurrentSegment() {
		return curAsInfos;
	}

	public void setAssessmentInfos(List<AssessmentInfo> newAsiList) {
		assessmentInfos = newAsiList;
		Collections.sort(assessmentInfos, new Comparator<AssessmentInfo>() {
			public int compare(AssessmentInfo as1, AssessmentInfo as2) {
				return as1.getName().compareToIgnoreCase(as2.getName());
			}
		});
	}

	public void resetAssessments() {
		currentAsIdx = 0;
	}

	public void setAsScoreValuesMap(List<AssessmentScoreValues> newAsvList) {
		asScoreValuesMap = new HashMap<String, AssessmentScoreValues>(17);
		for (AssessmentScoreValues asv : newAsvList) {
			asScoreValuesMap.put(SubjectManagementHelper
					.createScoreValueMapKey(asv.getAssessmentName(), asv
							.getSegmentID(), asv.getVisitID()), asv);
		}
	}

	public Map<String, AssessmentScoreValues> getScoreValuesMap() {
		return asScoreValuesMap;
	}

	public ScoreValuesDisplayLayout getScoreValuesDisplayLayout() {
		try {
			if (getAssessmentInfosForCurrentSegment().isEmpty()) {
				log
						.info("**** There are no AssessmentInfosForCurrentSegment() ");
				return new ScoreValuesDisplayLayout();
			}
			if (getAssessmentInfosForCurrentSegment().size() <= currentAsIdx) {
				log.info("**** Invalid currentAsIdx ");
				currentAsIdx = getAssessmentInfosForCurrentSegment().size() - 1;
			}
			int selSegmentID = GenUtils.toInt(getSelectedSegmentID(), -1);
			int selVisitID = GenUtils.toInt(getSelectedVisitID(), -1);
			if (selVisitID == -1 || selSegmentID == -1) {
				log.error("visitID or segmentID was not set! visitID="
						+ selVisitID + " segmentID=" + selSegmentID);
			}

			AssessmentInfo asi = getAssessmentInfosForCurrentSegment().get(
					currentAsIdx);

			log.info("%%%%%%  asi=" + asi.getName() + " currentAsIdx="
					+ currentAsIdx);
			if (log.isDebugEnabled()) {
				log.debug("%%%%%%  asi=" + asi.getName() + " currentAsIdx="
						+ currentAsIdx);
			}

			ScoreValuesDisplayLayout svdl = ScoreValuesDisplayHelper
					.getScoreValuesDisplayLayout(asi, selSegmentID, selVisitID,
							asScoreValuesMap);
			// move to the next assessment
			++currentAsIdx;

			return svdl;
		} catch (Throwable t) {
			log.error("in getScoreValuesDisplayLayout", t);
			if (t instanceof RuntimeException)
				throw (RuntimeException) t;
			return null;
		}
	}

	public int getMaxScoreNumber() {
		if (maxScoreNumber < 0) {
			for (Iterator<AssessmentInfo> iter = assessmentInfos.iterator(); iter
					.hasNext();) {
				AssessmentInfo asi = iter.next();
				if (asi.getScores().size() > maxScoreNumber) {
					maxScoreNumber = asi.getScores().size();
				}
			}
		}
		return maxScoreNumber;
	}

	public String getRemainingColumnSize(int idx) {
		AssessmentInfo asi = assessmentInfos.get(idx);
		return String.valueOf(maxScoreNumber - asi.getScores().size());
	}

	public String getSegmentTimestampValue() {
		System.out.println("####### getSegmentTimestampValue ="
				+ segmentTimestampValue);
		return segmentTimestampValue;
	}

	public void setSegmentTimestampValue(String ts) {
		this.segmentTimestampValue = ts;
	}

	public void addVisitDate(String date, String visitID) {
		visitDateLVBeans.add(new LabelValueBean(date, visitID));
	}

	public Collection<LabelValueBean> getVisitDates() {
		return visitDateLVBeans;
	}

	public String getVisitDateValue() {
		return visitDateValue;
	}

	public void setVisitDateValue(String newDate) {
		visitDateValue = newDate;
	}

	public void setSelectedSubjectValue(String newSelectedSubjectValue) {
		this.selectedSubjectValue = newSelectedSubjectValue;
	}

	public String getSelectedSubjectValue() {
		return this.selectedSubjectValue;
	}

	public void addSubject(Subject subj) {
		allSubjectLVBeans.add(new LabelValueBean(subj.getSubjectID(), subj
				.getSubjectID()));
	}

	public Collection<LabelValueBean> getAllSubjectLVBeans() {
		return allSubjectLVBeans;
	}

	public void setSubject(Subject sub) {
		this.subject = sub;
	}

	public Subject getSubject() {
		return this.subject;
	}

	public void setSelectedSubjectID(String newSelectedSubjectID) {
		this.selectedSubjectID = newSelectedSubjectID;
	}

	public String getSelectedSubjectID() {
		return this.selectedSubjectID;
	}

	public void setSelectedVisitID(String newSelectedVisitID) {
		this.selectedVisitID = newSelectedVisitID;
	}

	public String getSelectedVisitID() {
		return this.selectedVisitID;
	}

	public String getSelectedSegmentID() {
		return this.selectedSegmentID;
	}

	public void setSelectedSegmentID(String newSelectedSegmentID) {
		System.out.println("#### newSelectedSegmentID=" + newSelectedSegmentID);
		this.selectedSegmentID = newSelectedSegmentID;
	}

	public void setSelectedStudyID(String newSelectedStudyID) {
		this.selectedStudyID = newSelectedStudyID;
	}

	public String getSelectedStudyID() {
		return this.selectedStudyID;
	}

	public void setCurrentVisit(VisitFormInfo vfi) {
		this.currentVisit = vfi;
		log.info("new currentVisit =" + this.currentVisit);
	}

	public VisitFormInfo getCurrentVisit() {
		return this.currentVisit;
	}

	public StudyFormInfo getCurrentStudy() {
		int curStudyUniqID = -1;
		try {
			if (selectedStudyID != null) {
				try {
					curStudyUniqID = Integer.parseInt(selectedStudyID);
				} catch (NumberFormatException nfe) {
					curStudyUniqID = -1;
				}
			}

			VisitFormInfo vfi = getCurrentVisit();
			if (curStudyUniqID == -1000) {
				// the current study (just a template to be filled by the user)
				// that will be returned is for new study addition
				if (vfi.getStudyFormInfos().isEmpty()) {
					return null;
				} else {
					int lastIdx = vfi.getStudyFormInfos().size() - 1;

					StudyFormInfo sfi = (StudyFormInfo) vfi.getStudyFormInfos()
							.get(lastIdx);
					return sfi;
				}
			}

			if (curStudyUniqID == -1) {
				return null;
			}

			if (curStudyUniqID != -1) {
				for (StudyFormInfo sfi : vfi.getStudyFormInfos()) {
					if (sfi.getStudy().getStudyID() == curStudyUniqID) {
						return sfi;
					}
				}
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		log.info("returning null!");
		return null;
	}

	public SegmentFormInfo getCurrentSegment() {
		StudyFormInfo studyFI = getCurrentStudy();
		int curSegID = -1;
		if (selectedSegmentID != null) {
			try {
				curSegID = Integer.parseInt(selectedSegmentID);
			} catch (NumberFormatException nfe) {
				curSegID = -1;
			}
		}

		if (log.isDebugEnabled()) {
			log.debug("curSegID=" + curSegID);
			log.debug("has studyFI=" + (studyFI != null));
		}
		if (curSegID == -1) {
			if (studyFI != null) {
				int lastIdx = studyFI.getSegmentFormInfos().size() - 1;
				if (lastIdx >= 0) {
					return (SegmentFormInfo) studyFI.getSegmentFormInfos().get(
							lastIdx);
				} else {
					log.info(" studyFI != null curSegID == -1 returning null");
					log.info(">>> out getCurrentSegment");
					return null;
				}
			} else {
				// return the last segment in the current visits' segment list
				int lastIdx = getCurrentVisit().getSegmentFormInfos().size() - 1;
				return (SegmentFormInfo) getCurrentVisit()
						.getSegmentFormInfos().get(lastIdx);
			}
		}
		if (studyFI != null) {
			for (SegmentFormInfo sfi : studyFI.getSegmentFormInfos()) {
				if (sfi.getStudySegment().getSegmentID() == curSegID) {
					return sfi;
				}
			}
		} else {
			List<SegmentFormInfo> sfis = getCurrentVisit()
					.getSegmentFormInfos();
			for (SegmentFormInfo sfi : sfis) {
				if (sfi.getVisitSegment().getSegmentID() == curSegID) {
					return sfi;
				}
			}
		}
		log.info(" no current segment!");
		log.info(">>> out getCurrentSegment");
		return null;
	}

	//
	// indexed property
	public SegmentFormInfo getSfi(int idx) {
		StudyFormInfo sfi = getCurrentStudy();
		if (sfi != null) {
			return (SegmentFormInfo) sfi.getSegmentFormInfos().get(idx);
		} else {
			return (SegmentFormInfo) currentVisit.getSegmentFormInfos()
					.get(idx);
		}
	}

	public void addQueryPart(PropertyQueryPartInfo qpi) {
		queryParts.add(qpi);
	}

	public List<PropertyQueryPartInfo> getQueryParts() {
		return queryParts;
	}

	// indexed property
	public PropertyQueryPartInfo getQp(int idx) {
		return queryParts.get(idx);
	}

	// indexed property
	public String getCombinator(int idx) {
		return combinators[idx];
	}

	public String[] getCombinators() {
		return combinators;
	}

	public void setCombinator(int idx, String value) {
		combinators[idx] = value;
	}

	public void setCombinators(String[] combinators) {
		this.combinators = combinators;
	}

	public String getCurrentAction() {
		return currentAction;
	}

	public void setCurrentAction(String newAction) {
		currentAction = newAction;
	}

	public void addVisitType(String visitType) {
		if (visitTypes == null)
			visitTypes = new ArrayList<String>(2);
		visitTypes.add(visitType);
	}

	public List<String> getVisitTypes() {
		return visitTypes;
	}

	public void addProtocol(Protocol protocol) {
		protocols.add(protocol);
	}

	public void setProtocols(List<Protocol> protocols) {
		this.protocols = protocols;
	}

	public List<Protocol> getProtocols() {
		return protocols;
	}

	public void addExperiment(Experiment exp) {
		experiments.add(exp);
	}

	public List<Experiment> getExperiments() {
		return experiments;
	}

	public boolean getHasAssignedExperiments() {
		return (experiments != null && !experiments.isEmpty());
	}

	public void setSubjectSummaryList(List<Subject> list) {
		subjectSummaryList = list;
		// create the search result iterator with window size 20
		searchResultsIter = new SearchResultsIterator(subjectSummaryList, 20);
	}

	public List<Subject> getSubjectSummaryList() {
		return subjectSummaryList;
	}

	public SearchResultsIterator getSearchResultsIterator() {
		return searchResultsIter;
	}

	public Subject findSubject(String subjectID) {
		for (Subject subject : subjectSummaryList) {
			if (subject.getSubjectID().equals(subjectID))
				return subject;
		}
		return subject;
	}

	public void setExperimentValue(String newExperimentValue) {
		this.experimentValue = newExperimentValue;
	}

	public String getExperimentValue() {
		return this.experimentValue;
	}

	public void addExperimentLVBean(Experiment exp) {
		LabelValueBean lvb = new LabelValueBean(exp.getName(), exp
				.getUniqueid().toString());
		experimentLVBeans.add(lvb);
	}

	public Collection<LabelValueBean> getExperimentLVBeans() {
		return experimentLVBeans;
	}

	public void setExpSelector(SubjectExperimentsSelector newExpSelector) {
		this.expSelector = newExpSelector;
	}

	public SubjectExperimentsSelector getExpSelector() {
		return this.expSelector;
	}

	// for editable assessment selection dropdown
	public void setEditableAssessmentSelector(
			AssessmentSelector newEditableAssessmentSelector) {
		this.editableAssessmentSelector = newEditableAssessmentSelector;
	}

	public AssessmentSelector getEditableAssessmentSelector() {
		return this.editableAssessmentSelector;
	}

	// indexed property
	public String getEditableAssessment(int asIdx) {
		// log.info(" in getEditableAssessment asIdx="+ asIdx);
		List<AssessmentInfo> asInfosForCurSegment = getAssessmentInfosForCurrentSegment();
		if (asInfosForCurSegment == null || asInfosForCurSegment.isEmpty()) {
			log.info(" no asInfosForCurSegment ");
			return null;
		}
		if (asIdx < 0 || asIdx >= asInfosForCurSegment.size())
			return null;
		AssessmentInfo asi = asInfosForCurSegment.get(asIdx);
		if (log.isDebugEnabled()) {
			log.debug("asi=" + asi.getName());
			log.debug("asNames size " + allEditableAsNames.size());
		}
		for (String asName : allEditableAsNames) {
			if (asName.equals(asi.getName())) {
				return asName;
			}
		}
		return null;
	}

	public void setSelectedAsNameForEdit(String newSelectedAsNameForEdit) {
		this.selectedAsNameForEdit = newSelectedAsNameForEdit;
	}

	public String getSelectedAsNameForEdit() {
		return this.selectedAsNameForEdit;
	}

	public void setAllEditableAsNames(List<String> asNames) {
		this.allEditableAsNames = asNames;
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		/** @todo */
		return errors;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		this.selectedEntryID = null;
	}

	public void setStudySelector(StudySelector newStudySelector) {
		this.studySelector = newStudySelector;
	}

	public StudySelector getStudySelector() {
		return this.studySelector;
	}

	public void setEntryMap(Map<String, Integer> entryMap) {
		this.entryMap = entryMap;
	}

	public Map<String, Integer> getEntryMap() {
		return this.entryMap;
	}

	public void setSelectedEntryID(String newSelectedEntryID) {
		this.selectedEntryID = newSelectedEntryID;
	}

	public String getSelectedEntryID() {
		try {
			Integer.parseInt(this.selectedEntryID);
			return this.selectedEntryID;
		} catch (Exception e) {
			return null;
		}
	}

	public String getEntryCount(String asID) {
		if (entryMap == null) {
			return "-2";
		}
		Integer entryCount = entryMap.get(asID);
		log.info("asID=" + asID + " " + entryCount);
		if (entryCount == null)
			return "-1";
		return entryCount.toString();
	}

	public void setReconStatus(String asID, String status) {
		reconStatsMap.put(asID, status);
	}

	public String getReconStatus(String asID) {
		String status = reconStatsMap.get(asID);
		return status;
	}

	public SegmentTimestampSelector getSegTimestampSelector() {
		return segTimestampSelector;
	}

	public void setSegTimestampSelector(
			SegmentTimestampSelector segTimestampSelector) {
		this.segTimestampSelector = segTimestampSelector;
	}

	public void setEnrollExperimentSelector(
			SubjectExperimentsSelector expSelector) {
		this.enrollExperimentSelector = expSelector;

	}

	public SubjectExperimentsSelector getEnrollExperimentSelector() {
		return enrollExperimentSelector;
	}

	public void setExp2RGListJSON(String json) {
		this.exp2RGListJSON = json;

	}

	public String getExp2RGListJSON() {
		return exp2RGListJSON;
	}

	public String getSelectedResearchGroupId() {
		return selectedResearchGroupId;
	}

	public void setSelectedResearchGroupId(String selectedResearchGroupId) {
		this.selectedResearchGroupId = selectedResearchGroupId;
	}
}
