package clinical.web.game;

import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForm;

import clinical.server.vo.Dataclassification;
import clinical.web.common.UserInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ParameterGroup.java 62 2009-05-29 23:54:50Z bozyurt $
 */
class ParameterGroup {
   private String dbID;
   private UserInfo userInfo;
   private ActionForm form;
   private int pageNumber;
   private List<String> dbVarNames;
   private List<Dataclassification> dataClassifications;
   private int entryID;
   private Map<String, Map<String, String>> dbVarMetaDataMap;
   private AssessmentManagementHelper amh;

   public ParameterGroup(List<Dataclassification> classifications, String dbid,
         Map<String, Map<String, String>> map, List<String> names, int entryid, ActionForm form,
         int pageNumber, UserInfo info, AssessmentManagementHelper amh) {
      dataClassifications = classifications;
      dbID = dbid;
      dbVarMetaDataMap = map;
      dbVarNames = names;
      entryID = entryid;
      this.form = form;
      this.pageNumber = pageNumber;
      userInfo = info;
      this.amh = amh;
   }

   public List<Dataclassification> getDataClassifications() {
      return dataClassifications;
   }

   public void setDataClassifications(List<Dataclassification> dataClassifications) {
      this.dataClassifications = dataClassifications;
   }

   public String getDbID() {
      return dbID;
   }

   public void setDbID(String dbID) {
      this.dbID = dbID;
   }

   public Map<String, Map<String, String>> getDbVarMetaDataMap() {
      return dbVarMetaDataMap;
   }

   public void setDbVarMetaDataMap(Map<String, Map<String, String>> dbVarMetaDataMap) {
      this.dbVarMetaDataMap = dbVarMetaDataMap;
   }

   public List<String> getDbVarNames() {
      return dbVarNames;
   }

   public void setDbVarNames(List<String> dbVarNames) {
      this.dbVarNames = dbVarNames;
   }

   public int getEntryID() {
      return entryID;
   }

   public void setEntryID(int entryID) {
      this.entryID = entryID;
   }

   public ActionForm getForm() {
      return form;
   }

   public void setForm(ActionForm form) {
      this.form = form;
   }

   public int getPageNumber() {
      return pageNumber;
   }

   public void setPageNumber(int pageNumber) {
      this.pageNumber = pageNumber;
   }

   public UserInfo getUserInfo() {
      return userInfo;
   }

   public void setUserInfo(UserInfo userInfo) {
      this.userInfo = userInfo;
   }

   public AssessmentManagementHelper getAmh() {
      return amh;
   }

   public void setAmh(AssessmentManagementHelper amh) {
      this.amh = amh;
   }

}