package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.web.common.security.Privilege;

/**
 * @author I. Burak Ozyurt
 * @version $Id: PrivilegesSelector.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class PrivilegesSelector {
	protected Collection<LabelValueBean> privList;
	protected String selectedPrivilege;

	public PrivilegesSelector(List<Privilege> privileges) {
		privList = new ArrayList<LabelValueBean>(privileges.size());
		for (Privilege priv : privileges) {
			privList.add(new LabelValueBean(priv.getName(), priv.getName()));
			if (selectedPrivilege == null) {
				selectedPrivilege = priv.getName();
			}
		}
	}

	public Collection<LabelValueBean> getPrivList() {
		return privList;
	}

	public String getSelectedPrivilege() {
		return selectedPrivilege;
	}

	public void setSelectedPrivilege(String selectedPrivilege) {
		this.selectedPrivilege = selectedPrivilege;
	}	
}
